% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tt_compatibility.R
\name{rheader}
\alias{rheader}
\title{Create a header}
\usage{
rheader(..., format = "xx", .lst = NULL)
}
\arguments{
\item{...}{row specifications, either as character vectors or the output from \code{\link[=rrow]{rrow()}}, \code{\link[=DataRow]{DataRow()}},
\code{\link[=LabelRow]{LabelRow()}}, etc.}

\item{format}{(\code{string}, \code{function}, or \code{list})\cr the format label (string) or formatter function to apply to the
cell values passed via \code{...}. See \code{\link[formatters:list_formats]{formatters::list_valid_format_labels()}} for currently supported format labels.}

\item{.lst}{(\code{list})\cr an already-collected list of arguments to be used instead of the elements of \code{...}.
Arguments passed via \code{...} will be ignored if this is specified.}
}
\value{
A \code{InstantiatedColumnInfo} object.
}
\description{
Create a header
}
\examples{
h1 <- rheader(c("A", "B", "C"))
h1

h2 <- rheader(
  rrow(NULL, rcell("group 1", colspan = 2), rcell("group 2", colspan = 2)),
  rrow(NULL, "A", "B", "A", "B")
)
h2

}
\seealso{
Other compatibility: 
\code{\link{rrow}()},
\code{\link{rrowl}()},
\code{\link{rtable}()}
}
\concept{compatibility}
