% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_accessors.R
\name{value_formats}
\alias{value_formats}
\alias{value_formats,ANY-method}
\alias{value_formats,TableRow-method}
\alias{value_formats,LabelRow-method}
\alias{value_formats,VTableTree-method}
\title{Value Formats}
\usage{
value_formats(obj, default = obj_format(obj))

\S4method{value_formats}{ANY}(obj, default = obj_format(obj))

\S4method{value_formats}{TableRow}(obj, default = obj_format(obj))

\S4method{value_formats}{LabelRow}(obj, default = obj_format(obj))

\S4method{value_formats}{VTableTree}(obj, default = obj_format(obj))
}
\arguments{
\item{obj}{A table or row object.}

\item{default}{FormatSpec.}
}
\value{
Matrix (storage mode list) containing the effective format for each
cell position in the table (including 'virtual' cells implied by label rows,
whose formats are always \code{NULL})
}
\description{
Returns a matrix of formats for the cells in a table
}
\examples{

lyt <- basic_table() \%>\%
split_rows_by("RACE", split_fun = keep_split_levels(c("ASIAN", "WHITE"))) \%>\%
analyze("AGE")

tbl <- build_table(lyt, DM)
value_formats(tbl)
}
