% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_funs.R
\docType{data}
\name{select_all_levels}
\alias{select_all_levels}
\alias{add_combo_levels}
\title{Add Combination Levels to split}
\format{
An object of class \code{AllLevelsSentinel} of length 0.
}
\usage{
select_all_levels

add_combo_levels(combosdf, trim = FALSE, first = FALSE, keep_levels = NULL)
}
\arguments{
\item{combosdf}{data.frame/tbl_df. Columns valname, label, levelcombo, exargs. Of which levelcombo and exargs are list columns. Passing the \code{select_all_levels} object as a value in the \code{comblevels} column indicates that an overall/all-observations level should be created.}

\item{trim}{logical(1). Should splits corresponding with 0 observations be kept when tabulating.}

\item{first}{logical(1). Should the created split level be placed first in the levels (\code{TRUE}) or last (\code{FALSE}, the default).}

\item{keep_levels}{character or NULL. If non-NULL, the levels to retain across both combination and individual levels.}
}
\value{
a closure suitable for use as a splitting function (\code{splfun}) when creating a table layout
}
\description{
Add Combination Levels to split
}
\note{
Analysis or summary functions for which the order matters should never be used within the tabulation framework.
}
\examples{
library(tibble)
combodf <- tribble(
    ~valname, ~label, ~levelcombo, ~exargs,
    "A_B", "Arms A+B", c("A: Drug X", "B: Placebo"), list(),
    "A_C", "Arms A+C", c("A: Drug X", "C: Combination"), list())

l <- basic_table() \%>\%
    split_cols_by("ARM", split_fun = add_combo_levels(combodf)) \%>\%
    add_colcounts() \%>\%
    analyze("AGE")

build_table(l, DM)

la <- basic_table() \%>\%
    split_cols_by("ARM", split_fun = add_combo_levels(combodf, keep_levels = c("A_B", "A_C"))) \%>\%
    add_colcounts() \%>\%
    analyze("AGE")

build_table(la, DM)

smallerDM <- droplevels(subset(DM, SEX \%in\% c("M", "F") &
                        grepl("^(A|B)", ARM)))
l2 <- basic_table() \%>\%
    split_cols_by("ARM", split_fun = add_combo_levels(combodf[1,])) \%>\%
    split_cols_by("SEX", split_fun = add_overall_level("SEX_ALL", "All Genders")) \%>\%
    add_colcounts() \%>\%
    analyze("AGE")

l3 <-  basic_table() \%>\%
    split_cols_by("ARM", split_fun = add_combo_levels(combodf)) \%>\%
    add_colcounts() \%>\%
    split_rows_by("SEX", split_fun = add_overall_level("SEX_ALL", "All Genders")) \%>\%
    summarize_row_groups() \%>\%
    analyze("AGE")

build_table(l3, smallerDM)
}
\keyword{datasets}
