% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tt_paginate.R
\name{make_row_df}
\alias{make_row_df}
\alias{make_row_df,VTableTree-method}
\alias{make_row_df,TableRow-method}
\alias{make_row_df,LabelRow-method}
\alias{make_col_df}
\title{Make row and column layout summary data.frames for use during pagination}
\usage{
make_row_df(
  tt,
  colwidths = NULL,
  visible_only = TRUE,
  rownum = 0,
  indent = 0L,
  path = character(),
  incontent = FALSE,
  repr_ext = 0L,
  repr_inds = integer(),
  sibpos = NA_integer_,
  nsibs = NA_integer_
)

\S4method{make_row_df}{VTableTree}(
  tt,
  colwidths = NULL,
  visible_only = TRUE,
  rownum = 0,
  indent = 0L,
  path = character(),
  incontent = FALSE,
  repr_ext = 0L,
  repr_inds = integer(),
  sibpos = NA_integer_,
  nsibs = NA_integer_
)

\S4method{make_row_df}{TableRow}(
  tt,
  colwidths = NULL,
  visible_only = TRUE,
  rownum = 0,
  indent = 0L,
  path = "root",
  incontent = FALSE,
  repr_ext = 0L,
  repr_inds = integer(),
  sibpos = NA_integer_,
  nsibs = NA_integer_
)

\S4method{make_row_df}{LabelRow}(
  tt,
  colwidths = NULL,
  visible_only = TRUE,
  rownum = 0,
  indent = 0L,
  path = "root",
  incontent = FALSE,
  repr_ext = 0L,
  repr_inds = integer(),
  sibpos = NA_integer_,
  nsibs = NA_integer_
)

make_col_df(tt, visible_only = TRUE)
}
\arguments{
\item{tt}{TableTree (or related class). A TableTree object representing a populated table.}

\item{colwidths}{numeric. Internal detail do not set manually.}

\item{visible_only}{logical(1). Should only visible aspects of the table structure be reflected in this summary. Defaults to \code{TRUE}.}

\item{rownum}{numeric(1). Internal detail do not set manually.}

\item{indent}{integer(1). Internal detail do not set manually.}

\item{path}{character. A vector path for a position within the structure of a tabletree. Each element represents a subsequent choice amongst the children of the previous choice.}

\item{incontent}{logical(1). Internal detail do not set manually.}

\item{repr_ext}{integer(1). Internal detail do not set manually.}

\item{repr_inds}{integer. Internal detail do not set manually.}

\item{sibpos}{integer(1). Internal detail do not set manually.}

\item{nsibs}{integer(1). Internal detail do not set manually.}
}
\value{
a data.frame of row/column-structure information used by the pagination machinery.
}
\description{
Used for Pagination
}
\details{
When \code{visible_only} is \code{TRUE}, the resulting data.frame will have exactly one row per visible row in the table. This is useful when reasoning about how a table will print, but does not reflect the full pathing space of the structure (though the paths which are given will all work as is).

When \code{visible_only} is \code{FALSE}, every structural element of the table (in row-space) will be reflected in the returned data.frame, meaning the full pathing-space will be represented but some rows in the layout summary will not represent printed rows in the table as it is displayed.
}
\note{
the technically present root tree node is excluded from the summary returne dby
both \code{make_row_df} and \code{make_col_df}, as it is simply the
row/column structure of \code{tt} and thus not useful for pathing or pagination.
}
