% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/argument_conventions.R
\name{gen_args}
\alias{gen_args}
\title{General Argument Conventions}
\usage{
gen_args(
  df,
  alt_counts_df,
  spl,
  pos,
  tt,
  tr,
  verbose,
  colwidths,
  obj,
  x,
  value,
  object,
  path,
  label,
  visible_label,
  cvar,
  topleft,
  ...
)
}
\arguments{
\item{df}{dataset (data.frame or tibble)}

\item{alt_counts_df}{dataset (data.frame or tibble). Alternative full data the rtables framework will use (\emph{only})
when calculating column counts.}

\item{spl}{A Split object defining a partitioning or analysis/tabulation of the data.}

\item{pos}{numeric.  Which top-level set of nested splits should the new layout feature be added to. Defaults to the current}

\item{tt}{TableTree (or related class). A TableTree object representing a populated table.}

\item{tr}{TableRow (or related class). A TableRow object representing a single row within a populated table.}

\item{verbose}{logical(1). Should extra debugging messages be shown. Defaults to \code{FALSE}.}

\item{colwidths}{numeric vector. Column widths for use with vertical pagination. Currently ignored.}

\item{obj}{ANY. The object for the accessor to access or modify}

\item{x}{An object}

\item{value}{The new value}

\item{object}{The object to modify in-place}

\item{path}{character. A vector path for a position within the structure of a tabletree. Each element represents a subsequent choice amongst the children of the previous choice.}

\item{label}{character(1). A label (not to be confused with the name) for the object/structure.}

\item{visible_label}{logical(1). Should the \emph{split} label be visible in the resulting table.}

\item{cvar}{character(1). The variable, if any, which the content function should accept. Defaults to NA.}

\item{topleft}{character. Override values for the "top left" material to be displayed during printing.}

\item{\dots}{Passed on to metthods or tabulation functions.}
}
\value{
NULL (this is an argument template dummy function)
}
\description{
General Argument Conventions
}
\seealso{
Other conventions: 
\code{\link{compat_args}()},
\code{\link{constr_args}()},
\code{\link{lyt_args}()},
\code{\link{sf_args}()}
}
\concept{conventions}
