# Copyright (c) 2023 Apex Resource Management Solution Ltd. (ApexRMS). All rights reserved.
# MIT License

#' rsyncrosim: The R interface to SyncroSim: https://syncrosim.com/
#'
#' rsyncrosim provides an interface to SyncroSim, a generalized framework for
#' running and managing scenario-based stochastic simulations over space and time.
#' Different kinds of simulation models can "plug-in" to SyncroSim as packages and
#' take advantage of general features common to many kinds of simulation models,
#' such as defining scenarios of inputs, running Monte Carlo simulations, and
#' viewing charts and maps of outputs.
#'
#' To learn more about rsyncrosim, start with the vignette tutorial:
#' \code{browseVignettes("rsyncrosim")}.
#'
#' @docType package
#' @name rsyncrosim
#' @aliases rsyncrosim-package
#' @import methods
#' @importFrom gtools smartbind
#' @importFrom utils capture.output flush.console head read.csv write.csv packageVersion
NULL
