% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project.R
\name{project}
\alias{project}
\title{Create or open Project(s)}
\usage{
project(
  ssimObject = NULL,
  project = NULL,
  sourceProject = NULL,
  summary = NULL,
  forceElements = FALSE,
  overwrite = FALSE
)
}
\arguments{
\item{ssimObject}{\code{\link{Scenario}} or 
\code{\link{SsimLibrary}} object, or a character string (i.e. a filepath)}

\item{project}{\code{\link{Project}} object, character, integer, or vector 
of these. Names or ids of one or more Projects. Note that integer ids are 
slightly faster (optional)}

\item{sourceProject}{\code{\link{Project}} object, character, or integer. If 
not \code{NULL} (default), new Projects will be copies of the sourceProject}

\item{summary}{logical. If \code{TRUE} then return the Project(s) in a data.frame with 
the projectId, name, description, owner, dateModified, readOnly. Default 
is \code{TRUE} if \code{project=NULL} and SsimObject is not Scenario/Project, \code{FALSE} 
otherwise}

\item{forceElements}{logical. If \code{TRUE} then returns a single Project as a named 
list; otherwise returns a single project as a \code{\link{Project}} object. 
Applies only when \code{summary=FALSE} Default is \code{FALSE}}

\item{overwrite}{logical. If \code{TRUE} an existing Project will be overwritten. 
Default is \code{FALSE}}
}
\value{
Returns a \code{\link{Project}} object representing a SyncroSim Project. If 
summary is \code{TRUE}, returns a data.frame of Project names and descriptions.
}
\description{
Creates or retrieves a \code{\link{Project}} or multiple Projects from a
SsimLibrary.
}
\details{
For each element of project:
\itemize{
  \item {If element identifies an existing Project: }{Returns the existing Project}.
  \item {If element identifies more than one Project: }{Error}.
  \item {If element does not identify an existing Project: }{Creates a new Project 
  named element. Note that SyncroSim automatically assigns an id to a new Project.}
}
}
\examples{
\donttest{
# Set the file path and name of the new SsimLibrary
myLibraryName <- file.path(tempdir(),"testlib_project")

# Set the SyncroSim Session, SsimLibrary, and Project
mySession <- session()
myLibrary <- ssimLibrary(name = myLibraryName, session = mySession) 
myProject <- project(ssimObject = myLibrary, project = "My project name")
myproject2 <- project(ssimObject = myLibrary, project = "My new project name")

# Get a named list of existing Projects
# Each element in the list is named by a character version of the Project ID
myProjects <- project(myLibrary, summary = FALSE)
names(myProjects)

# Get an existing Project.
myProject <- myProjects[[1]]
myProject <- project(myLibrary, project = "My new project name")

# Get/set the Project properties
name(myProject)
name(myProject) <- "New project name"

# Create a new Project from a copy of an existing Project
myNewProject <- project(myLibrary, project = "My copied project",
                        sourceProject = 1)

# Overwrite an existing Project
myNewProject <- project(myLibrary, project = "My copied project",
                        overwrite = TRUE)
}

}
