% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/breakpoint.R
\name{deleteBreakpoint}
\alias{deleteBreakpoint}
\alias{deleteBreakpoint,Scenario-method}
\title{Delete a Scenario breakpoint.}
\usage{
deleteBreakpoint(x, transformerName = NULL, breakpointType = NULL)

\S4method{deleteBreakpoint}{Scenario}(x, transformerName = NULL, breakpointType = NULL)
}
\arguments{
\item{x}{A SyncroSim Scenario.}

\item{transformerName}{A Stochastic Time Transformer (e.g. stsim_Runtime).  Optional.}

\item{breakpointType}{bi: before iteration; ai: after iteration; bt:before timestep; at: after timestep.  Optional.}
}
\value{
A SyncroSim Scenario with an updated list of breakpoints.
}
\description{
This function will delete a Scenario breakpoint.
}
\examples{
\donttest{

temp_dir <- tempdir()
myses <- session()
mylib <- ssimLibrary(name = file.path(temp_dir,"testlib"), session = myses)
myScenario <- scenario(mylib, "testScenario")

myScenario <- deleteBreakpoint(myScenario)
myScenario <- deleteBreakpoint(myScenario, transformerName = "stsim_Runtime")
}
}
