% Generated by roxygen2 (4.0.1): do not edit by hand
\name{os_statemetasearch}
\alias{os_statemetasearch}
\title{Search OpenStates metadata.}
\usage{
os_statemetasearch(state = NULL, key = getOption("SunlightLabsKey",
  stop("need an API key for Sunlight Labs")), ...)
}
\arguments{
\item{state}{One or more two-letter state abbreviations (character)}

\item{key}{your SunlightLabs API key; or loads from .Rprofile}

\item{...}{Curl options passed on to httr::GET}
}
\value{
A list with metadata for each state.
}
\description{
Search OpenStates metadata.
}
\examples{
\dontrun{
os_statemetasearch()
os_statemetasearch('ca')
os_statemetasearch('tx')
out <- os_statemetasearch(c('tx','nv'))
out$tx
out$nv

library('httr')
os_statemetasearch('tx', config=verbose())
}
}

