/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.subgroup.quality.functions;

import org.vikamine.kernel.subgroup.SG;
import org.vikamine.kernel.subgroup.quality.AbstractQFSimpleStatisticBased;

public class WRAccQF
extends AbstractQFSimpleStatisticBased {
    private static final String ID = "WRAccQF";
    private static final String NAME = "Weighted relative Accuracy";

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public double evaluateNum(double subgroupSize, double subgroupMean, double definedPopulationCount, double populationMean) {
        double subgroupQuality = subgroupSize / definedPopulationCount * (subgroupMean - populationMean);
        if (Double.isNaN(subgroupQuality)) {
            subgroupQuality = Double.NEGATIVE_INFINITY;
        }
        return subgroupQuality;
    }

    @Override
    public double evaluateBin(double subgroupSize, double subgroupPositives, double definedPopulationCount, double populationPositives) {
        double p = subgroupPositives / subgroupSize;
        double p0 = populationPositives / definedPopulationCount;
        double subgroupQuality = subgroupSize / definedPopulationCount * (p - p0);
        if (Double.isNaN(subgroupQuality)) {
            subgroupQuality = Double.NEGATIVE_INFINITY;
        }
        return subgroupQuality;
    }

    @Override
    public AbstractQFSimpleStatisticBased clone() {
        return new WRAccQF();
    }

    @Override
    public boolean isApplicable(SG subgroup) {
        return subgroup.getTarget() != null && subgroup.getTarget().isBoolean();
    }
}

