/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.data.creators;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.vikamine.kernel.data.DataRecordSet;
import org.vikamine.kernel.data.Ontology;
import org.vikamine.kernel.data.OntologyConstants;
import org.vikamine.kernel.data.RDFStatement;
import org.vikamine.kernel.data.converters.KeelDataConverter;
import org.vikamine.kernel.data.creators.AbstractOntologyCreator;
import org.vikamine.kernel.data.creators.IFileSourceOntologyCreator;

public class KeelDataOntologyCreator
extends AbstractOntologyCreator
implements IFileSourceOntologyCreator {
    public static final String EXTENSION = "dat";
    private File file;
    private boolean isSparse;

    public KeelDataOntologyCreator() {
    }

    public KeelDataOntologyCreator(String keelString) throws IllegalStateException {
        this.dataset = this.importDataRecordFromKeelString(keelString);
    }

    public KeelDataOntologyCreator(DataRecordSet theInstances) {
        this.dataset = theInstances;
    }

    private DataRecordSet importDataRecordFromKeelString(String keelString) {
        KeelDataConverter keelReader = new KeelDataConverter(new StringReader(keelString));
        keelReader.setImportStringAttributes(false);
        this.isSparse = keelReader.isSparse();
        try {
            return keelReader.createDataRecordSet();
        }
        catch (IOException e) {
            Logger.getLogger(KeelDataOntologyCreator.class.getName()).throwing(KeelDataOntologyCreator.class.getName(), "Problem with the keel-dat format of" + keelString, e);
            throw new IllegalStateException(e);
        }
    }

    private DataRecordSet importInstancesFromKeelFile(boolean importStringAttributes) throws IOException {
        DataRecordSet inst = null;
        try {
            String extension;
            Reader r = new BufferedReader(new FileReader(this.file));
            int dotPos = this.file.getName().lastIndexOf(".");
            if (dotPos != -1 && (extension = this.file.getName().substring(dotPos)).equals(".zip")) {
                ZipFile zipFile = new ZipFile(this.file);
                ZipEntry zEntry = zipFile.entries().nextElement();
                BufferedInputStream bis = new BufferedInputStream(zipFile.getInputStream(zEntry));
                r = new InputStreamReader(bis);
            }
            KeelDataConverter keelReader = new KeelDataConverter(r);
            keelReader.setImportStringAttributes(importStringAttributes);
            inst = keelReader.createDataRecordSet();
            this.isSparse = keelReader.isSparse();
            ((Reader)r).close();
        }
        catch (FileNotFoundException fnfex) {
            Logger.getLogger(KeelDataOntologyCreator.class.getName()).throwing(KeelDataOntologyCreator.class.getName(), "File not found " + this.file, fnfex);
            throw new IOException(fnfex);
        }
        catch (IOException ioex) {
            Logger.getLogger(KeelDataOntologyCreator.class.getName()).throwing(KeelDataOntologyCreator.class.getName(), "Problem with the keel format of" + this.file, ioex);
            throw new IOException(ioex);
        }
        return inst;
    }

    @Override
    public Ontology createOntology() {
        if (this.dataset != null) {
            Ontology ontology = new Ontology(this.dataset);
            this.createIDAttribute();
            if (this.file != null) {
                ontology.getTripleStore().addStatement(new RDFStatement<Ontology, String>(ontology, OntologyConstants.DATASET_FILETYPE_PROPERTY, ".dat"));
                ontology.getTripleStore().addStatement(new RDFStatement<Ontology, String>(ontology, OntologyConstants.DATASET_FILE_NAME_PROPERTY, this.file != null ? this.file.getName() : "unknown"));
                RDFStatement<Ontology, String> absolutePathStatement = new RDFStatement<Ontology, String>(ontology, OntologyConstants.DATASET_FILE_ABSOLUTE_PATH_PROPERTY, this.file.getAbsolutePath());
                ontology.getTripleStore().addStatement(absolutePathStatement);
            }
            if (this.isSparse) {
                ontology.getTripleStore().addStatement(new RDFStatement<Ontology, String>(ontology, OntologyConstants.DEFAULT_VALUE_PROPERTY, "0"));
            }
            this.copyAttributesToOntology(ontology);
            ontology.getTripleStore().addStatement(new RDFStatement<Ontology, String>(ontology, OntologyConstants.DATASET_RELATION_NAME_PROPERTY, this.dataset.getRelationName()));
            return ontology;
        }
        return null;
    }

    @Override
    public Ontology createOntology(File file) throws IOException {
        return this.createOntology(file, true);
    }

    public Ontology createOntology(File file, boolean importStringAttributes) throws IOException {
        this.file = file;
        this.dataset = this.importInstancesFromKeelFile(importStringAttributes);
        return this.createOntology();
    }
}

