/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.data.creators;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.vikamine.kernel.data.DataRecordSet;
import org.vikamine.kernel.data.IDataRecordSet;
import org.vikamine.kernel.data.Ontology;
import org.vikamine.kernel.data.converters.CSVDataConverter;
import org.vikamine.kernel.data.converters.CSVDataConverterConfig;
import org.vikamine.kernel.data.creators.ARFFDataOntologyCreator;
import org.vikamine.kernel.data.creators.CSVDataOntologyCreator;
import org.vikamine.kernel.data.creators.DBConnector;
import org.vikamine.kernel.data.creators.DBDataOntologyCreator;
import org.vikamine.kernel.data.creators.DTPDataOntologyCreator;
import org.vikamine.kernel.data.creators.IFileSourceOntologyCreator;
import org.vikamine.kernel.data.creators.KeelDataOntologyCreator;

public class DataFactory {
    private static HashMap<String, IFileSourceOntologyCreator> EXTRA_FILE_EXTENSION_HANDLERS = new HashMap();

    public static void addHandler(String extension, IFileSourceOntologyCreator creator) {
        EXTRA_FILE_EXTENSION_HANDLERS.put(extension, creator);
    }

    public static boolean removeHandler(String extension) {
        return EXTRA_FILE_EXTENSION_HANDLERS.remove(extension) != null;
    }

    protected DataFactory() {
    }

    public static Ontology createOntology(DataRecordSet theInstances) {
        return new ARFFDataOntologyCreator(theInstances).createOntology();
    }

    public static Ontology createOntologyFromString(String arffString) {
        return new ARFFDataOntologyCreator(arffString).createOntology();
    }

    public static Ontology createOntology(File file) throws IOException {
        int dotPos = file.getName().lastIndexOf(".");
        if (dotPos != -1) {
            String extension = file.getName().substring(dotPos + 1);
            if (extension.equals("csv")) {
                return DataFactory.createOntologyFromCSVFile(file, CSVDataConverter.getStandardCsvConfiguration());
            }
            if (extension.equals("arff")) {
                return new ARFFDataOntologyCreator().createOntology(file);
            }
            if (extension.equals("dat")) {
                return new KeelDataOntologyCreator().createOntology(file);
            }
            for (Map.Entry<String, IFileSourceOntologyCreator> entry : EXTRA_FILE_EXTENSION_HANDLERS.entrySet()) {
                if (!entry.getKey().equals(extension)) continue;
                IFileSourceOntologyCreator creator = entry.getValue();
                return creator.createOntology(file);
            }
        }
        return new ARFFDataOntologyCreator().createOntology(file);
    }

    public static void saveRecordSetAsARFF(File file, IDataRecordSet instances, Ontology om) {
        try {
            FileOutputStream out = new FileOutputStream(file);
            PrintStream ps = new PrintStream(out);
            ps.print(instances.printInstances(om));
            ps.close();
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(DataFactory.class.getName()).throwing(DataFactory.class.getName(), "appendConvertedToARFFBaseFile", ex);
        }
    }

    public static void saveOntologyAsARFF(File file, Ontology om, boolean includeIDAttribute) {
        try {
            FileOutputStream out = new FileOutputStream(file);
            PrintStream ps = new PrintStream(out);
            ps.print(om.printAllAttributes(includeIDAttribute));
            ps.close();
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(DataFactory.class.getName()).throwing(DataFactory.class.getName(), "appendConvertedToARFFBaseFile", ex);
        }
    }

    public static Ontology createOntologyFromCSVFile(File csvFile, CSVDataConverterConfig csvConfiguration) throws IOException {
        return new CSVDataOntologyCreator(csvFile, csvConfiguration).createOntology();
    }

    public static Ontology createOntologyFromDTP(ResultSet data, String name) throws SQLException {
        return new DTPDataOntologyCreator(data, name).createOntology();
    }

    public static Ontology createOntologyFromDBData(DBConnector db, String name) throws IOException {
        return new DBDataOntologyCreator(db, name).createOntology();
    }

    public static Ontology createOntologyFromDBData(ResultSet resultset, ArrayList<String> list) {
        return new DBDataOntologyCreator(resultset, list).createOntology();
    }

    public static Ontology createEmptyOntology() {
        return Ontology.createEmptyOntology();
    }
}

