/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.data.creators;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.vikamine.kernel.data.DataRecordSet;
import org.vikamine.kernel.data.Ontology;
import org.vikamine.kernel.data.OntologyConstants;
import org.vikamine.kernel.data.RDFStatement;
import org.vikamine.kernel.data.converters.ARFFDataConverter;
import org.vikamine.kernel.data.creators.AbstractOntologyCreator;
import org.vikamine.kernel.data.creators.IFileSourceOntologyCreator;

public class ARFFDataOntologyCreator
extends AbstractOntologyCreator
implements IFileSourceOntologyCreator {
    public static final String EXTENSION = "arff";
    private File file;
    private boolean isSparse;
    private boolean createIDAttribute = true;

    public ARFFDataOntologyCreator() {
    }

    public ARFFDataOntologyCreator(String arff) throws IllegalStateException {
        this.dataset = this.importDataRecordFromARFFString(arff);
    }

    public ARFFDataOntologyCreator(DataRecordSet theInstances) {
        this.dataset = theInstances;
    }

    private DataRecordSet importDataRecordFromARFFString(String arff) {
        ARFFDataConverter arffReader = new ARFFDataConverter(new StringReader(arff));
        arffReader.setImportStringAttributes(false);
        this.isSparse = arffReader.isSparse();
        try {
            return arffReader.createDataRecordSet();
        }
        catch (IOException e) {
            Logger.getLogger(ARFFDataOntologyCreator.class.getName()).throwing(ARFFDataOntologyCreator.class.getName(), "Problem with the arff format of" + arff, e);
            throw new IllegalStateException(e);
        }
    }

    private DataRecordSet importInstancesFromARFFFile(boolean importStringAttributes) throws IOException {
        DataRecordSet inst = null;
        try {
            String extension;
            FileReader fileReader = new FileReader(this.file);
            Reader r = new BufferedReader(fileReader);
            int dotPos = this.file.getName().lastIndexOf(".");
            if (dotPos != -1 && (extension = this.file.getName().substring(dotPos)).equals(".zip")) {
                ZipFile zipFile = new ZipFile(this.file);
                ZipEntry zEntry = zipFile.entries().nextElement();
                BufferedInputStream bis = new BufferedInputStream(zipFile.getInputStream(zEntry));
                r = new InputStreamReader(bis);
            }
            ARFFDataConverter arffReader = new ARFFDataConverter(r);
            arffReader.setImportStringAttributes(importStringAttributes);
            inst = arffReader.createDataRecordSet();
            this.isSparse = arffReader.isSparse();
            ((Reader)r).close();
        }
        catch (FileNotFoundException fnfex) {
            Logger.getLogger(ARFFDataOntologyCreator.class.getName()).throwing(ARFFDataOntologyCreator.class.getName(), "File not found " + this.file, fnfex);
            throw new IOException(fnfex);
        }
        catch (IOException ioex) {
            Logger.getLogger(ARFFDataOntologyCreator.class.getName()).throwing(ARFFDataOntologyCreator.class.getName(), "Problem with the arff format of" + this.file, ioex);
            throw new IOException(ioex);
        }
        return inst;
    }

    @Override
    public Ontology createOntology() {
        if (this.dataset != null) {
            Ontology ontology = new Ontology(this.dataset);
            if (this.isCreateIDAttribute()) {
                this.createIDAttribute();
            }
            if (this.file != null) {
                ontology.getTripleStore().addStatement(new RDFStatement<Ontology, String>(ontology, OntologyConstants.DATASET_FILETYPE_PROPERTY, ".arff"));
                ontology.getTripleStore().addStatement(new RDFStatement<Ontology, String>(ontology, OntologyConstants.DATASET_FILE_NAME_PROPERTY, this.file != null ? this.file.getName() : "unknown"));
                RDFStatement<Ontology, String> absolutePathStatement = new RDFStatement<Ontology, String>(ontology, OntologyConstants.DATASET_FILE_ABSOLUTE_PATH_PROPERTY, this.file.getAbsolutePath());
                ontology.getTripleStore().addStatement(absolutePathStatement);
            }
            if (this.isSparse) {
                ontology.getTripleStore().addStatement(new RDFStatement<Ontology, String>(ontology, OntologyConstants.DEFAULT_VALUE_PROPERTY, "0"));
            }
            this.copyAttributesToOntology(ontology);
            ontology.getTripleStore().addStatement(new RDFStatement<Ontology, String>(ontology, OntologyConstants.DATASET_RELATION_NAME_PROPERTY, this.dataset.getRelationName()));
            return ontology;
        }
        return null;
    }

    @Override
    public Ontology createOntology(File file) throws IOException {
        return this.createOntology(file, true);
    }

    public Ontology createOntology(File file, boolean importStringAttributes) throws IOException {
        this.file = file;
        this.dataset = this.importInstancesFromARFFFile(importStringAttributes);
        return this.createOntology();
    }

    public boolean isCreateIDAttribute() {
        return this.createIDAttribute;
    }

    public void setCreateIDAttribute(boolean createIDAttribute) {
        this.createIDAttribute = createIDAttribute;
    }
}

