/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import org.vikamine.kernel.data.Attribute;
import org.vikamine.kernel.data.AttributeProvider;
import org.vikamine.kernel.data.DataRecord;
import org.vikamine.kernel.data.DataRecordSet;
import org.vikamine.kernel.data.DataView;
import org.vikamine.kernel.data.IDataRecordSet;
import org.vikamine.kernel.data.OntologyConstants;
import org.vikamine.kernel.data.RDFStatement;
import org.vikamine.kernel.data.RDFTripleStore;
import org.vikamine.kernel.subgroup.selectors.SGSelector;
import org.vikamine.kernel.util.VKMUtil;

public class Ontology
implements AttributeProvider {
    private IDataRecordSet dataset = null;
    private DataView population;
    private LinkedHashMap<String, Attribute> attributes = new LinkedHashMap();
    private final List<Attribute> userDefinedAttributes = new LinkedList<Attribute>();
    private final RDFTripleStore tripleStore = new RDFTripleStore();

    public static Ontology createEmptyOntology() {
        Ontology o = new Ontology();
        o.population = new DataView(new DataRecordSet("", (List<Attribute>)Collections.EMPTY_LIST, 0), Collections.EMPTY_LIST);
        return o;
    }

    protected Ontology() {
    }

    public Ontology(DataRecordSet dataset) {
        this();
        if (dataset == null) {
            IllegalStateException ex = new IllegalStateException("The dataset " + dataset + " is null!");
            Logger.getLogger(this.getClass().getName()).throwing(this.getClass().getName(), "Ontology", ex);
            throw ex;
        }
        this.dataset = dataset;
        this.population = new DataView(dataset, Collections.EMPTY_LIST);
    }

    public void addUserDefinedAttribute(Attribute att) {
        if (this.addAttribute(att)) {
            this.userDefinedAttributes.add(att);
        }
    }

    public Attribute findUserDefinedAttribute(String id) {
        for (Attribute att : this.userDefinedAttributes) {
            if (!att.getId().equals(id)) continue;
            return att;
        }
        return null;
    }

    public boolean addAttribute(Attribute att) {
        if (!this.attributes.containsKey(att.getId())) {
            this.attributes.put(att.getId(), att);
            return true;
        }
        return false;
    }

    @Override
    public Attribute getAttribute(String id) {
        Attribute attribute = this.attributes.get(id);
        if (attribute != null) {
            return attribute;
        }
        return this.findUserDefinedAttribute(id);
    }

    public boolean isIDAttribute(Attribute att) {
        return att.equals(this.getIDAttribute());
    }

    public Attribute getIDAttribute() {
        return this.dataset.getAttribute(0);
    }

    public LinkedHashSet<Attribute> getAttributes() {
        return this.getAttributes(true);
    }

    public LinkedHashSet<Attribute> getAttributes(boolean includeIDAttribute) {
        LinkedHashSet<Attribute> allAttributes = new LinkedHashSet<Attribute>(this.attributes.values());
        if (!includeIDAttribute) {
            allAttributes.remove(this.getIDAttribute());
        }
        return allAttributes;
    }

    public Attribute getAttribute(int index) {
        int i = 0;
        for (Attribute att : this.attributes.values()) {
            if (i == index) {
                return att;
            }
            ++i;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public IDataRecordSet getDataset() {
        return this.dataset;
    }

    @Override
    public int getNumAttributes() {
        return this.getAttributes().size();
    }

    public DataView getDataView() {
        return this.population;
    }

    public List<Attribute> getUserDefinedAttributes() {
        return this.userDefinedAttributes;
    }

    public void refinePopulation(List<SGSelector> populationRangesSelectors) {
        this.population = new DataView(this.dataset, populationRangesSelectors);
    }

    public boolean removeUserDefinedAttribute(Attribute att) {
        return this.removeAttribute(att) & this.userDefinedAttributes.remove(att);
    }

    public boolean removeAttribute(Attribute att) {
        return this.attributes.remove(att.getId()) != null;
    }

    public void setAttributes(List<Attribute> dmAttributes) {
        this.attributes = new LinkedHashMap(dmAttributes.size());
        for (Attribute attribute : dmAttributes) {
            this.attributes.put(attribute.getId(), attribute);
        }
    }

    public RDFTripleStore getTripleStore() {
        return this.tripleStore;
    }

    public String printAllAttributes(boolean includeIDAttribute) {
        Comparator<Attribute> attComp = new Comparator<Attribute>(){

            @Override
            public int compare(Attribute o1, Attribute o2) {
                return o1.getId().compareToIgnoreCase(o2.getId());
            }
        };
        ArrayList<Attribute> attList = new ArrayList<Attribute>(this.getAttributes());
        if (!includeIDAttribute) {
            attList.remove(this.getIDAttribute());
        }
        Collections.sort(attList, attComp);
        return this.printAttributes(attList);
    }

    public String printAttributes(Collection<Attribute> attList) {
        StringBuilder buddy = new StringBuilder();
        buddy.append("@relation ").append(VKMUtil.quote(this.dataset.getRelationName())).append("\n\n");
        for (Attribute att : attList) {
            buddy.append(att).append("\n");
        }
        buddy.append("\n@data\n");
        int i = 0;
        while (i < this.dataset.getNumInstances()) {
            int counter = 0;
            for (Attribute att : attList) {
                DataRecord record = this.dataset.get(i);
                if (counter != 0) {
                    buddy.append(",");
                }
                if (record.isMissing(att)) {
                    buddy.append('?');
                } else if (att.isNumeric()) {
                    buddy.append(record.getValue(att));
                } else {
                    buddy.append(VKMUtil.quote(record.getStringValue(att)));
                }
                ++counter;
            }
            buddy.append("\n");
            ++i;
        }
        return buddy.toString();
    }

    public void setDataset(DataRecordSet dataset) {
        this.dataset = dataset;
    }

    public String getDatasetName() {
        RDFStatement datasetNameStatement = this.getTripleStore().getFirstMatchingStatement("**ANY_OBJECT**", OntologyConstants.DATASET_FILE_NAME_PROPERTY, "**ANY_OBJECT**");
        String datasetName = "unknown";
        if (datasetNameStatement != null) {
            datasetName = (String)datasetNameStatement.getObject();
        }
        return datasetName;
    }
}

