% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/launcher-functions.R
\name{launcher}
\alias{launcher}
\alias{launcherGetInfo}
\alias{launcherAvailable}
\alias{launcherGetJobs}
\title{Retrieve Launcher Information}
\usage{
launcherGetInfo()

launcherAvailable()

launcherGetJobs(statuses = NULL, fields = NULL, tags = NULL,
  includeSessions = FALSE)
}
\arguments{
\item{statuses}{Return only jobs whose status matches one of \code{statuses}.
Valid statuses are: Pending, Running, Suspended, Failed, Finished, Killed,
Canceled. When \code{NULL}, all jobs are returned.}

\item{fields}{Return a subset of fields associated with each job object.
When \code{NULL}, all fields associated with a particular job are returned.}

\item{tags}{An optional set of tags. Only jobs that have been assigned one
of these requested tags will be returned.}

\item{includeSessions}{Boolean; include jobs which are also operating
as RStudio R sessions?}
}
\description{
Retrieve information about the launcher, as well as the different clusters
that the launcher has been configured to use.

Check if the RStudio launcher is available and configured to support
'ad-hoc' jobs; that is, jobs normally launched by the user through
the RStudio IDE's user interface.

Retrieve information on launcher jobs.
}
