% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_predict.R
\name{posterior_predict}
\alias{posterior_predict}
\title{Generic function for drawing from the posterior predictive distribution}
\usage{
posterior_predict(object, ...)
}
\arguments{
\item{object}{The object to use.}

\item{...}{Arguments passed to methods. See the methods in the \pkg{rstanarm}
package for examples.}
}
\value{
\code{posterior_predict} methods should return a \eqn{D} by \eqn{N}
  matrix, where \eqn{D} is the number of draws from the posterior predictive
  distribution and \eqn{N} is the number of data points being predicted per
  draw.
}
\description{
Draw from the posterior predictive distribution of the outcome. See
\code{\link[rstanarm]{posterior_predict.stanreg}} in the
\pkg{\link[rstanarm]{rstanarm}} package for an example.
}
\examples{
# Example using rstanarm package:
# posterior_predict method for 'stanreg' objects
\donttest{
if (require("rstanarm")) {
  fit <- stan_glm(mpg ~ wt + am, data = mtcars)
  yrep <- posterior_predict(fit)
  all.equal(ncol(yrep), nobs(fit))

  nd <- data.frame(wt = mean(mtcars$wt), am = c(0, 1))
  ytilde <- posterior_predict(fit, newdata = nd)
  all.equal(ncol(ytilde), nrow(nd))
}
}

# Also see help("posterior_predict", package = "rstanarm")

}
\seealso{
\itemize{
  \item The \pkg{\link[rstanarm]{rstanarm}} package for example methods
  (\href{https://CRAN.R-project.org/package=rstanarm}{CRAN},
  \href{https://github.com/stan-dev/rstanarm}{GitHub}).
}

\itemize{
  \item The guidelines for developers of \R packages interfacing with Stan, a
  copy of which can be found in the package vignettes. See
  \code{browseVignettes("rstantools")} or \code{vignette(package =
  "rstantools")}. The document is also available online at the
  \pkg{rstantools} page on the
  \href{https://CRAN.R-project.org/package=rstantools/vignettes/developer-guidelines.html}{CRAN
  website}.
}
}
