% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/example_model.R
\name{example_model}
\alias{example_model}
\title{Example model}
\format{A \code{\link[=stanreg-objects]{stanreg}} object containing the
  output from fitting the model in the Examples section, below.
  The \code{chains} and \code{iter} arguments are specified to make this example be 
  small in size. In practice, we recommend that they be left unspecified in
  order to use the default values (4 and 2000 respectively) or increased if
  there are convergence problems. The \code{cores} argument is optional and
  on a multicore system, the user may well want to set that equal to the
  number of chains being executed.}
\description{
A pre-fit model for use in \pkg{rstanarm} examples.
}
\examples{
\dontrun{
example_model <- 
  stan_glmer(cbind(incidence, size - incidence) ~ size + period + (1|herd),
             data = lme4::cbpp, family = binomial,
             # this next line is only to keep the example small in size!
             chains = 2, cores = 1, seed = 12345, iter = 500)
}
example_model
}
\seealso{
\code{\link[lme4]{cbpp}} for a description of the data.
}

