% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stan_nlmer.R
\name{stan_nlmer}
\alias{stan_nlmer}
\title{Bayesian nonlinear models with group-specific terms via Stan}
\usage{
stan_nlmer(
  formula,
  data = NULL,
  subset,
  weights,
  na.action,
  offset,
  contrasts = NULL,
  ...,
  prior = normal(),
  prior_aux = exponential(),
  prior_covariance = decov(),
  prior_PD = FALSE,
  algorithm = c("sampling", "meanfield", "fullrank"),
  adapt_delta = NULL,
  QR = FALSE,
  sparse = FALSE
)
}
\arguments{
\item{formula, data}{Same as for \code{\link[lme4]{nlmer}}. \emph{We strongly
advise against omitting the \code{data} argument}. Unless \code{data} is
specified (and is a data frame) many post-estimation functions (including
\code{update}, \code{loo}, \code{kfold}) are not guaranteed to work
properly.}

\item{subset, weights, offset}{Same as \code{\link[stats]{glm}}.}

\item{na.action, contrasts}{Same as \code{\link[stats]{glm}}, but rarely 
specified.}

\item{...}{Further arguments passed to the function in the \pkg{rstan} 
package (\code{\link[rstan]{sampling}}, \code{\link[rstan]{vb}}, or 
\code{\link[rstan]{optimizing}}), corresponding to the estimation method 
named by \code{algorithm}. For example, if \code{algorithm} is
\code{"sampling"} it is possibly to specify \code{iter}, \code{chains},
\code{cores}, \code{refresh}, etc.}

\item{prior}{The prior distribution for the regression coefficients. 
\code{prior} should be a call to one of the various functions provided by 
\pkg{rstanarm} for specifying priors. The subset of these functions that 
can be used for the prior on the coefficients can be grouped into several 
"families":

\tabular{ll}{
  \strong{Family} \tab \strong{Functions} \cr 
  \emph{Student t family} \tab \code{normal}, \code{student_t}, \code{cauchy} \cr 
  \emph{Hierarchical shrinkage family} \tab \code{hs}, \code{hs_plus} \cr 
  \emph{Laplace family} \tab \code{laplace}, \code{lasso} \cr
  \emph{Product normal family} \tab \code{product_normal} \cr
}

See the \link[=priors]{priors help page} for details on the families and 
how to specify the arguments for all of the functions in the table above.
To omit a prior ---i.e., to use a flat (improper) uniform prior---
\code{prior} can be set to \code{NULL}, although this is rarely a good
idea.

\strong{Note:} Unless \code{QR=TRUE}, if \code{prior} is from the Student t
family or Laplace family, and if the \code{autoscale} argument to the 
function used to specify the prior (e.g. \code{\link{normal}}) is left at 
its default and recommended value of \code{TRUE}, then the default or 
user-specified prior scale(s) may be adjusted internally based on the
scales of the predictors. See the \link[=priors]{priors help page} and the
\emph{Prior Distributions} vignette for details on the rescaling and the
\code{\link{prior_summary}} function for a summary of the priors used for a
particular model.}

\item{prior_aux}{The prior distribution for the "auxiliary" parameter (if
applicable). The "auxiliary" parameter refers to a different parameter 
depending on the \code{family}. For Gaussian models \code{prior_aux} 
controls \code{"sigma"}, the error 
standard deviation. For negative binomial models \code{prior_aux} controls 
\code{"reciprocal_dispersion"}, which is similar to the 
\code{"size"} parameter of \code{\link[stats]{rnbinom}}:
smaller values of \code{"reciprocal_dispersion"} correspond to 
greater dispersion. For gamma models \code{prior_aux} sets the prior on 
to the \code{"shape"} parameter (see e.g., 
\code{\link[stats]{rgamma}}), and for inverse-Gaussian models it is the 
so-called \code{"lambda"} parameter (which is essentially the reciprocal of
a scale parameter). Binomial and Poisson models do not have auxiliary 
parameters. 

\code{prior_aux} can be a call to \code{exponential} to 
use an exponential distribution, or \code{normal}, \code{student_t} or 
\code{cauchy}, which results in a half-normal, half-t, or half-Cauchy 
prior. See \code{\link{priors}} for details on these functions. To omit a 
prior ---i.e., to use a flat (improper) uniform prior--- set 
\code{prior_aux} to \code{NULL}.}

\item{prior_covariance}{Cannot be \code{NULL}; see \code{\link{decov}} for
more information about the default arguments.}

\item{prior_PD}{A logical scalar (defaulting to \code{FALSE}) indicating
whether to draw from the prior predictive distribution instead of
conditioning on the outcome.}

\item{algorithm}{A string (possibly abbreviated) indicating the 
estimation approach to use. Can be \code{"sampling"} for MCMC (the
default), \code{"optimizing"} for optimization, \code{"meanfield"} for
variational inference with independent normal distributions, or
\code{"fullrank"} for variational inference with a multivariate normal
distribution. See \code{\link{rstanarm-package}} for more details on the
estimation algorithms. NOTE: not all fitting functions support all four
algorithms.}

\item{adapt_delta}{Only relevant if \code{algorithm="sampling"}. See 
the \link{adapt_delta} help page for details.}

\item{QR}{A logical scalar defaulting to \code{FALSE}, but if \code{TRUE}
applies a scaled \code{\link{qr}} decomposition to the design matrix. The
transformation does not change the likelihood of the data but is
recommended for computational reasons when there are multiple predictors.
See the \link{QR-argument} documentation page for details on how
\pkg{rstanarm} does the transformation and important information about how
to interpret the prior distributions of the model parameters when using
\code{QR=TRUE}.}

\item{sparse}{A logical scalar (defaulting to \code{FALSE}) indicating
whether to use a sparse representation of the design (X) matrix. 
If \code{TRUE}, the the design matrix is not centered (since that would 
destroy the sparsity) and likewise it is not possible to specify both 
\code{QR = TRUE} and \code{sparse = TRUE}. Depending on how many zeros
there are in the design matrix, setting \code{sparse = TRUE} may make
the code run faster and can consume much less RAM.}
}
\value{
A \link[=stanreg-objects]{stanreg} object is returned 
for \code{stan_nlmer}.
}
\description{
\if{html}{\figure{stanlogo.png}{options: width="25px" alt="http://mc-stan.org/about/logo/"}}
Bayesian inference for NLMMs with group-specific coefficients that have 
unknown covariance matrices with flexible priors.
}
\details{
The \code{stan_nlmer} function is similar in syntax to 
  \code{\link[lme4]{nlmer}} but rather than performing (approximate) maximum 
  marginal likelihood estimation, Bayesian estimation is by default performed
  via MCMC. The Bayesian model adds independent priors on the "coefficients"
  --- which are really intercepts --- in the same way as 
  \code{\link{stan_nlmer}} and priors on the terms of a decomposition of the 
  covariance matrices of the group-specific parameters. See
  \code{\link{priors}} for more information about the priors.
  
  The supported transformation functions are limited to the named 
  "self-starting" functions in the \pkg{stats} library:
  \code{\link[stats]{SSasymp}}, \code{\link[stats]{SSasympOff}},
  \code{\link[stats]{SSasympOrig}}, \code{\link[stats]{SSbiexp}},
  \code{\link[stats]{SSfol}}, \code{\link[stats]{SSfpl}},
  \code{\link[stats]{SSgompertz}}, \code{\link[stats]{SSlogis}},
  \code{\link[stats]{SSmicmen}}, and \code{\link[stats]{SSweibull}}.
}
\examples{
\donttest{
data("Orange", package = "datasets")
Orange$circumference <- Orange$circumference / 100
Orange$age <- Orange$age / 100
fit <- stan_nlmer(
  circumference ~ SSlogis(age, Asym, xmid, scal) ~ Asym|Tree, 
  data = Orange, 
  # for speed only
  chains = 1, 
  iter = 1000
 ) 
print(fit)
posterior_interval(fit)
plot(fit, regex_pars = "b\\\\[")
}
}
\seealso{
\code{\link{stanreg-methods}} and 
\code{\link[lme4]{nlmer}}.

The vignette for \code{stan_glmer}, which also discusses 
  \code{stan_nlmer} models. \url{http://mc-stan.org/rstanarm/articles/}
}
