% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_vs_prior.R
\name{posterior_vs_prior}
\alias{posterior_vs_prior}
\alias{posterior_vs_prior.stanreg}
\title{Juxtapose prior and posterior}
\usage{
posterior_vs_prior(object, ...)

\method{posterior_vs_prior}{stanreg}(object, pars = NULL, regex_pars = NULL,
  prob = 0.9, color_by = c("parameter", "vs", "none"),
  group_by_parameter = FALSE, facet_args = list(), ...)
}
\arguments{
\item{object}{A fitted model object returned by one of the 
\pkg{rstanarm} modeling functions. See \code{\link{stanreg-objects}}.}

\item{...}{The S3 generic uses \code{...} to pass arguments to any defined 
methods. For the method for stanreg objects, \code{...} is for arguments
(other than \code{color}) passed to \code{\link[ggplot2]{geom_pointrange}}
to control the appearance of the plotted intervals.}

\item{pars}{An optional character vector specifying a subset of parameters to
display. Parameters can be specified by name or several shortcuts can be 
used. Using \code{pars="beta"} will restrict the displayed parameters to 
only the regression coefficients (without the intercept). \code{"alpha"} 
can also be used as a shortcut for \code{"(Intercept)"}. If the model has 
varying intercepts and/or slopes they can be selected using \code{pars = 
"varying"}. If \code{pars} is \code{NULL} all parameters are selected. See 
Examples.}

\item{regex_pars}{An optional character vector of \link[=grep]{regular 
expressions} to use for parameter selection. \code{regex_pars} can be used
in place of \code{pars} or in addition to \code{pars}. Currently, all
functions that accept a \code{regex_pars} argument ignore it for models fit
using optimization.}

\item{prob}{A number \eqn{p \in (0,1)}{p (0 < p < 1)} indicating the desired 
posterior probability mass to include in the (central posterior) interval 
estimates displayed in the plot. The default is \eqn{0.9}.}

\item{color_by}{How should the estimates be colored? Use \code{"parameter"} 
to color by parameter name, \code{"vs"} to color the prior one color and 
the posterior another, and \code{"none"} to use no color. Except when 
\code{color_by="none"}, a variable is mapped to the color 
\code{\link[ggplot2]{aes}}thetic and it is therefore also possible to
change the default colors by adding one of the various discrete color
scales available in \code{ggplot2} 
(\code{\link[ggplot2]{scale_color_manual}}, 
\code{\link[ggplot2]{scale_color_brewer}}, etc.). See Examples.}

\item{group_by_parameter}{Should estimates be grouped together by parameter
(\code{TRUE}) or by posterior and prior (\code{FALSE}, the default)?}

\item{facet_args}{A named list of arguments passed to
\code{\link[ggplot2]{facet_wrap}} (other than the \code{facets} argument),
e.g., \code{nrow} or \code{ncol} to change the layout, \code{scales} to 
allow axis scales to vary across facets, etc. See Examples.}
}
\value{
A ggplot object that can be further customized using the 
  \pkg{ggplot2} package.
}
\description{
Plot medians and central intervals comparing parameter draws from the prior 
and posterior distributions. If the plotted priors look different than the 
priors you think you specified it is likely either because of internal 
rescaling or the use of the \code{QR} argument (see the documentation for the
\code{\link[=prior_summary.stanreg]{prior_summary}} method for details on 
these special cases).
}
\examples{
if (!exists("example_model")) example(example_model)
# display non-varying (i.e. not group-level) coefficients
posterior_vs_prior(example_model, pars = "beta")

\dontrun{
# show group-level (varying) parameters and group by parameter
posterior_vs_prior(example_model, pars = "varying",
                   group_by_parameter = TRUE, color_by = "vs")

# group by parameter and allow axis scales to vary across facets
posterior_vs_prior(example_model, regex_pars = "period",
                   group_by_parameter = TRUE, color_by = "none",
                   facet_args = list(scales = "free"))

# assign to object and customize with functions from ggplot2
(gg <- posterior_vs_prior(example_model, pars = c("beta", "varying"), prob = 0.8))

gg + 
 ggplot2::geom_hline(yintercept = 0, size = 0.3, linetype = 3) + 
 ggplot2::coord_flip() + 
 ggplot2::ggtitle("Comparing the prior and posterior")
 
# compare very wide and very narrow priors using roaches example
# (see help(roaches, "rstanarm") for info on the dataset)
roaches$roach100 <- roaches$roach1 / 100
wide_prior <- normal(0, 10)
narrow_prior <- normal(0, 0.1)
fit_pois_wide_prior <- stan_glm(y ~ treatment + roach100 + senior, 
                                offset = log(exposure2), 
                                family = "poisson", data = roaches, 
                                prior = wide_prior)
posterior_vs_prior(fit_pois_wide_prior, pars = "beta", prob = 0.5, 
                   group_by_parameter = TRUE, color_by = "vs", 
                   facet_args = list(scales = "free"))
                   
fit_pois_narrow_prior <- update(fit_pois_wide_prior, prior = narrow_prior)
posterior_vs_prior(fit_pois_narrow_prior, pars = "beta", prob = 0.5, 
                   group_by_parameter = TRUE, color_by = "vs", 
                   facet_args = list(scales = "free"))
                   

# look at cutpoints for ordinal model
fit_polr <- stan_polr(tobgp ~ agegp, data = esoph, method = "probit",
                      prior = R2(0.2, "mean"), init_r = 0.1)
(gg_polr <- posterior_vs_prior(fit_polr, regex_pars = "\\\\|", color_by = "vs",
                               group_by_parameter = TRUE))
# flip the x and y axes
gg_polr + ggplot2::coord_flip()
}

}

