% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictive_interval.R
\name{predictive_interval.stanreg}
\alias{predictive_interval}
\alias{predictive_interval.ppd}
\alias{predictive_interval.stanreg}
\title{Predictive intervals}
\usage{
\method{predictive_interval}{stanreg}(object, prob = 0.9, newdata = NULL,
  draws = NULL, re.form = NULL, fun = NULL, seed = NULL,
  offset = NULL, ...)

\method{predictive_interval}{ppd}(object, prob = 0.9, ...)
}
\arguments{
\item{object}{Either a fitted model object returned by one of the 
\pkg{rstanarm} modeling functions (a \link[=stanreg-objects]{stanreg 
object}) or, for the \code{"ppd"} method, a matrix of draws from the 
posterior predictive distribution returned by 
\code{\link{posterior_predict}}.}

\item{prob}{A number \eqn{p \in (0,1)}{p (0 < p < 1)} indicating the desired
probability mass to include in the intervals. The default is to report
\eqn{90}\% intervals (\code{prob=0.9}) rather than the traditionally used
\eqn{95}\% (see Details).}

\item{newdata, draws, fun, offset, re.form, seed}{Passed to 
\code{\link[=posterior_predict]{posterior_predict}}.}

\item{...}{Currently ignored.}
}
\value{
A matrix with two columns and as many rows as are in \code{newdata}. 
  If \code{newdata} is not provided then the matrix will as many rows as in
  the data used to fit the model. For a given value of \code{prob}, \eqn{p},
  the columns correspond to the lower and upper \eqn{100p}\% central interval
  limits and have the names \eqn{100\alpha/2}\% and \eqn{100(1 -
  \alpha/2)}\%, where \eqn{\alpha = 1-p}. For example, if \code{prob=0.9} is
  specified (a \eqn{90}\% interval), then the column names will be
  \code{"5\%"} and \code{"95\%"}, respectively.
}
\description{
For models fit using MCMC (\code{algorithm="sampling"}) or one of the 
variational approximations (\code{"meanfield"} or \code{"fullrank"}), the 
\code{predictive_interval} function computes Bayesian predictive intervals. 
The method for stanreg objects calls \code{posterior_predict} internally, 
whereas the method for objects of class \code{"ppd"} accepts the matrix 
returned by \code{posterior_predict} as input and can be used to avoid
multiple calls to \code{posterior_predict}.
}
\examples{
fit <- stan_glm(mpg ~ wt, data = mtcars, iter = 300)
predictive_interval(fit)
predictive_interval(fit, newdata = data.frame(wt = range(mtcars$wt)), 
                    prob = 0.5)

# stanreg vs ppd methods
preds <- posterior_predict(fit, seed = 123)
all.equal(
  predictive_interval(fit, seed = 123),
  predictive_interval(preds)
)

}
\seealso{
\code{\link{predictive_error}}, \code{\link{posterior_predict}}, 
  \code{\link{posterior_interval}}
}

