% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_WRMF.R
\name{WRMF}
\alias{WRMF}
\title{Weighted Regularized Matrix Facrtorization for collaborative filtering}
\description{
Creates matrix factorization model which could be solved with Alternating Least Squares (Weighted ALS for implicit feedback).
For implicit feedback see "Collaborative Filtering for Implicit Feedback Datasets" (Hu, Koren, Volinsky).
For explicit feedback model is classic model for rating matrix decomposition with MSE error (without biases at the moment).
These two algorithms are proven to work well in recommender systems.
}
\examples{
data('movielens100k')
train = movielens100k[1:900, ]
cv = movielens100k[901:nrow(movielens100k), ]
model = WRMF$new(rank = 5,  lambda = 0, feedback = 'implicit')
user_emb = model$fit_transform(train, n_iter = 5, convergence_tol = -1)
item_emb = model$components
preds = model$predict(cv, k = 10, not_recommend = cv)
}
\references{
\itemize{
  \item{\url{https://math.stackexchange.com/questions/1072451/analytic-solution-for-matrix-factorization-using-alternating-least-squares/1073170#1073170}}
  \item{\url{http://activisiongamescience.github.io/2016/01/11/Implicit-Recommender-Systems-Biased-Matrix-Factorization/}}
  \item{\url{http://datamusing.info/blog/2015/01/07/implicit-feedback-and-collaborative-filtering/}}
  \item{\url{https://jessesw.com/Rec-System/}}
  \item{\url{http://danielnee.com/2016/09/collaborative-filtering-using-alternating-least-squares/}}
  \item{\url{http://www.benfrederickson.com/matrix-factorization/}}
  \item{\url{http://www.benfrederickson.com/fast-implicit-matrix-factorization/}}
}
}
\section{Super class}{
\code{\link[rsparse:MatrixFactorizationRecommender]{rsparse::MatrixFactorizationRecommender}} -> \code{WRMF}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{WRMF$new()}}
\item \href{#method-fit_transform}{\code{WRMF$fit_transform()}}
\item \href{#method-transform}{\code{WRMF$transform()}}
\item \href{#method-clone}{\code{WRMF$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="rsparse" data-topic="MatrixFactorizationRecommender" data-id="predict">}\href{../../rsparse/html/MatrixFactorizationRecommender.html#method-predict}{\code{rsparse::MatrixFactorizationRecommender$predict()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
creates WRMF model
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WRMF$new(
  rank = 10L,
  lambda = 0,
  init = NULL,
  preprocess = identity,
  feedback = c("implicit", "explicit"),
  non_negative = FALSE,
  solver = c("conjugate_gradient", "cholesky"),
  cg_steps = 3L,
  precision = c("double", "float"),
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rank}}{size of the latent dimension}

\item{\code{lambda}}{regularization parameter}

\item{\code{init}}{initialization of item embeddings}

\item{\code{preprocess}}{\code{identity()} by default. User spectified function which will
be applied to user-item interaction matrix before running matrix factorization
(also applied during inference time before making predictions).
For example we may want to normalize each row of user-item matrix to have 1 norm.
Or apply \code{log1p()} to discount large counts.
This corresponds to the "confidence" function from
"Collaborative Filtering for Implicit Feedback Datasets" paper.}

\item{\code{feedback}}{\code{character} - feedback type - one of \code{c("implicit", "explicit")}}

\item{\code{non_negative}}{logical, whether to perform non-negative factorization}

\item{\code{solver}}{\code{character} - solver for "implicit feedback" problem.
One of \code{c("conjugate_gradient", "cholesky")}.
Usually approximate \code{"conjugate_gradient"} is significantly faster and solution is
on par with \code{"cholesky"}}

\item{\code{cg_steps}}{\code{integer > 0} - max number of internal steps in conjugate gradient
(if "conjugate_gradient" solver used). \code{cg_steps = 3} by default.
Controls precision of linear equation solution at the each ALS step. Usually no need to tune this parameter}

\item{\code{precision}}{one of \code{c("double", "float")}. Should embeeding matrices be
numeric or float (from \code{float} package). The latter is usually 2x faster and
consumes less RAM. BUT \code{float} matrices are not "base" objects. Use carefully.}

\item{\code{...}}{not used at the moment}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-fit_transform"></a>}}
\if{latex}{\out{\hypertarget{method-fit_transform}{}}}
\subsection{Method \code{fit_transform()}}{
fits the model
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WRMF$fit_transform(x, n_iter = 10L, convergence_tol = 0.005, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{input matrix (preferably matrix  in CSC format -`CsparseMatrix`}

\item{\code{n_iter}}{max number of ALS iterations}

\item{\code{convergence_tol}}{convergence tolerance checked between iterations}

\item{\code{...}}{not used at the moment}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-transform"></a>}}
\if{latex}{\out{\hypertarget{method-transform}{}}}
\subsection{Method \code{transform()}}{
create user embeddings for new input
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WRMF$transform(x, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{user-item iteraction matrix}

\item{\code{...}}{not used at the moment}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WRMF$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
