% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/adjusted.R
\name{adjusted}
\alias{adjusted}
\alias{print.adjusted}
\title{Adjusted object}
\usage{
\method{print}{adjusted}(x, maxprint = 10, ...)
}
\arguments{
\item{x}{an object of class \code{adjusted}}

\item{maxprint}{max number of output values to print}

\item{...}{parameters to pass to other methds}
}
\description{
Adjusted object
}
\section{Details}{

A \code{adjusted} object contains the adjusted vector as well as some information on how
the adjustment was achieved. In particular, it contains the following slots (to be accessed with
the dollar operator):
   \itemize{
      \item{ \code{\$x}: the adjusted vector.}
      \item{ \code{\$accuracy}: Maximum deviance of \code{\$x} from the constraints (see \code{\link{adjust}} for details).}
      \item{ \code{\$objective} : Square root of objective function \eqn{\sum_i(x_i-x^0_i)^2w_i}.}
      \item{ \code{\$duration}: \code{proc_time} object showing time it took to run the adjustment. (See \code{proc.time}).}
      \item{ \code{\$niter}: Number of iterations.}
      \item{ \code{\$status}: A \code{character} string stating whether the adjustment was successful,
               aborted, or if the maximum number of iterations was reached before convergence. }
      \item{ \code{\$method}: \code{'sparse'} or \code{'dense'}.}
   }
}
\seealso{
\code{\link{adjust}}
}

