% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.multisimsum.R
\name{autoplot.multisimsum}
\alias{autoplot.multisimsum}
\title{autoplot method for multisimsum objects}
\usage{
\method{autoplot}{multisimsum}(
  object,
  par,
  type = "forest",
  stats = "bias",
  target = NULL,
  fitted = TRUE,
  scales = "fixed",
  top = TRUE,
  density.legend = TRUE,
  zoom = 1,
  ...
)
}
\arguments{
\item{object}{An object of class \code{multisimsum}.}

\item{par}{The parameter results to plot.}

\item{type}{The type of the plot to be produced. Possible choices are: \code{forest}, \code{lolly}, \code{zip}, \code{est}, \code{se}, \code{est_ba}, \code{se_ba}, \code{est_density}, \code{se_density}, \code{est_hex}, \code{se_hex}, \code{est_ridge}, \code{se_ridge}, \code{heat}, \code{nlp}, with \code{forest} being the default.}

\item{stats}{Summary statistic to plot, defaults to \code{bias}. See \code{\link[=summary.simsum]{summary.simsum()}} for further details on supported summary statistics.}

\item{target}{Target of summary statistic, e.g. 0 for \code{bias}. Defaults to \code{NULL}, in which case target will be inferred.}

\item{fitted}{Superimpose a fitted regression line, useful when \code{type} = (\code{est}, \code{se}, \code{est_ba}, \code{se_ba}, \code{est_density}, \code{se_density}, \code{est_hex}, \code{se_hex}). Defaults to \code{TRUE}.}

\item{scales}{Should scales be fixed (\code{fixed}, the default), free (\code{free}), or free in one dimension (\code{free_x}, \code{free_y})?}

\item{top}{Should the legend for a nested loop plot be on the top side of the plot? Defaults to \code{TRUE}.}

\item{density.legend}{Should the legend for density and hexbin plots be included? Defaults to \code{TRUE}.}

\item{zoom}{A numeric value between 0 and 1 signalling that a zip plot should \emph{zoom} on the top x\% of the plot (to ease interpretation). Defaults to 1, where the whole zip plot is displayed.}

\item{...}{Not used.}
}
\value{
A \code{ggplot} object.
}
\description{
\code{autoplot} can produce a series of plot to summarise results of simulation studies. See \code{vignette("plotting", package = "rsimsum")} for further details.
}
\examples{
data("frailty", package = "rsimsum")
ms <- multisimsum(
  data = frailty,
  par = "par", true = c(trt = -0.50, fv = 0.75),
  estvarname = "b", se = "se", methodvar = "model",
  by = "fv_dist", x = TRUE
)

library(ggplot2)
autoplot(ms, par = "trt")
autoplot(ms, par = "trt", type = "lolly", stats = "cover")
autoplot(ms, par = "trt", type = "zip")
autoplot(ms, par = "trt", type = "est_ba")
autoplot(ms, par = "trt", type = "zip")
}
