% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zip.simsum.R
\name{zip.simsum}
\alias{zip.simsum}
\title{zip method for simsum objects}
\usage{
\method{zip}{simsum}(obj, wald.level = 0.95, gpars = list(), ...)
}
\arguments{
\item{obj}{An object of class \code{simsum}.}

\item{wald.level}{Confidence level of the Wald test used to compute p-values for sorting each confidence interval. Defaults to \code{0.95}.}

\item{gpars}{Graphical parameters. Must be a named list, with possible parameters:
\itemize{
\item \code{ci.alpha}, alpha value of each individual confidence interval;
\item \code{true.colour}, colour of the vertical line at \code{true} value;
\item \code{true.shape}, shape of the vertical line at \code{true} value;
\item \code{ci.colour}, colour of the horizontal lines representing confidence intervals for estimated coverage based on Monte Carlo standard errors;
\item \code{ci.shape}, shape of the horizontal lines representing confidence intervals for estimated coverage based on Monte Carlo standard errors.
}

It is possible to redefine all the graphical parameters of a subset only; if not specified, sensible default values will be utilised.}

\item{...}{Ignored.}
}
\value{
A \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} object that can be combined with additional \code{geom_*}, \code{scale_*}, \code{theme_*}, etc.
}
\description{
\code{\link[=zip]{zip()}} method for objects of class \code{simsum}.
}
\examples{
library(rsimsum)
library(ggplot2)
data("relhaz", package = "rsimsum")
s <- simsum(data = relhaz, estvarname = "theta", true = -0.5, se = "se",
  methodvar = "model", by = c("n", "baseline"), x = TRUE)
zip(s)
data("MIsim", package = "rsimsum")
s2 <- simsum(data = MIsim, estvarname = "b", true = 0.5, se = "se",
  methodvar = "method", x = TRUE)
zip(s2)
}
