% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coords-utils.R, R/extendr-wrappers.R
\name{coord_n}
\alias{coord_n}
\alias{n_coords}
\alias{coord_first}
\alias{coord_last}
\title{Coordinate Utilities}
\usage{
coord_n(x, n)

n_coords(x)

coord_first(x)

coord_last(x)
}
\arguments{
\item{x}{an object of class \code{rsgeo}}

\item{n}{the index position of the coordinate}
}
\value{
an object of class \code{rs_POINT}.
Whereas \code{n_coords()} returns an integer vector of the same length as \code{x}.
}
\description{
Utility functions for accessing coordinates from a geometry.
}
\details{
\itemize{
\item \code{n_coords} returns the total number of coordinates in a geometry
\item \code{coord_first()} returns the first coordinate in a geometry
\item \code{coord_last()} returns the last coordinate in a geometry
\item \code{coord_n()} returns the nth coordinate in a geometry
}
}
\examples{
lines <- geom_linestring(1:10, 1:10)
n_coords(lines)
coord_first(lines)
coord_last(lines)
coord_n(lines, 5)
}
