% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deployDoc.R
\name{deployDoc}
\alias{deployDoc}
\title{Deploy a Document}
\usage{
deployDoc(doc, ...)
}
\arguments{
\item{doc}{Path to the document to deploy.}

\item{...}{Additional arguments to \code{\link{deployApp}}. Do not supply
\code{appDir}, \code{appFiles}, or \code{appPrimaryDoc};
these three parameters are automatically generated by \code{deployDoc} from
the document.}
}
\description{
Deploys an application consisting of a single R Markdown document or other
single file (such as an HTML or PDF document).
}
\details{
When deploying an R Markdown document, any files which are
  required to render and display the file must be deployed.

  This method discovers these additional files using
  \code{\link[rmarkdown:find_external_resources]{find_external_resources}}
  from \pkg{rmarkdown}.

  If you find that the document is missing dependencies, either specify the
  dependencies explicitly in the document (the documentation for
  \code{\link[rmarkdown:find_external_resources]{find_external_resources}}
  explains how to do this), or call \code{\link{deployApp}} directly and
  specify your own file list in the \code{appFiles} parameter.
}
