% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scala.R
\name{scala}
\alias{scala}
\alias{rscala-package}
\title{Instantiate a Scala Bridge}
\usage{
scala(JARs = character(), serialize.output = .Platform$OS.type ==
  "windows", stdout = TRUE, stderr = TRUE, port = 0L,
  heap.maximum = NULL, command.line.arguments = character(0),
  debug = FALSE)
}
\arguments{
\item{JARs}{Character vector whose elements are some combination of
individual JAR files or package names which contain embedded JARs.  These
JAR files are added to the runtime classpath.}

\item{serialize.output}{Logical indicating whether Scala output should be
serialized back to R.  This is slower and probably only needed on Windows.}

\item{stdout}{Whether "standard output" results that are not serialized
should be sent.  \code{TRUE} or \code{""} sends output to the \R console
(although that may not work on Windows).  \code{FALSE} or \code{NULL}
discards the output.  Otherwise, this is the name of the file that receives
the output.}

\item{stderr}{Same as \code{stdout}, except influences the "standard error".}

\item{port}{If \code{0}, two random ports are selected.  Otherwise,
\code{port} and \code{port+1} are used to the TCP/IP connections.}

\item{heap.maximum}{String giving Scala's heap maximum, e.g., "8G" or "512M".
The value here supersedes that from \code{\link{scalaMemory}}. Without this
being set in either \code{\link{scala}} or \code{\link{scalaMemory}}, the
heap maximum will be 90\% of the available RAM.}

\item{command.line.arguments}{A character vector of extra command line
arguments to pass to the Scala executable, where each element corresponds
to one argument.}

\item{debug}{(Developer use only.)  Logical indicating whether debugging
should be enabled.}
}
\value{
Returns an rscala bridge.
}
\description{
This function creates an instance of an rscala bridge.  Details on this
function (and the rscala package as a whole) are provided in the package
vignette and the associated paper in the \emph{Journal of Statistical
Software}. See the reference below.
}
\details{
Multiple interpreters can be created and each runs independently with its own
memory space. Each interpreter can use multiple threads/cores, but the bridge
between \R and Scala is itself not thread-safe, so multiple \R threads/cores
should not simultaneously access the same bridge.

Terminate the bridge using \code{\link{close.rscalaBridge}}.
}
\examples{
\donttest{
s <- scala()
rng <- s $ .new_scala.util.Random()
rng $ alphanumeric() $ take(15L) $ mkString(',')
s * '2+3'
h <- s(x=2, y=3) ^ 'x+y'
h $ toString()
s(mean=h, sd=2, r=rng) * 'mean + sd * r.nextGaussian()'
close(s)
}

}
\references{
{David B. Dahl (2018). “Integration of R and Scala Using rscala.”
  Journal of Statistical Software, in editing. https://www.jstatsoft.org}
}
\seealso{
\code{\link{close.rscalaBridge}}, \code{\link{scalaMemory}}
  \code{\link{scalaPushRegister}}, \code{\link{scalaPullRegister}}
}
