% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compat-dplyr.R
\name{rsample-dplyr}
\alias{rsample-dplyr}
\title{Compatibility with dplyr}
\description{
This page lays out the compatibility between rsample and dplyr. The \code{rset}
objects from rsample are a specific subclass of tibbles, hence standard
dplyr operations like joins as well row or column modifications work.
However, whether the operation returns an rset or a tibble depends on the
details of the operation.

The overarching principle is that any operation which leaves the specific
characteristics of an rset intact will return an rset. If an operation
modifies any of the following characteristics, the result will be a \code{tibble}
rather than an \code{rset}:
\itemize{
\item Rows: The number of rows needs to remain unchanged to retain the rset
property. For example, you can't have a 10-fold CV object without 10 rows.
The order of the rows can be changed though and the object remains an rset.
\item Columns: The \code{splits} column and the \code{id} column(s) are required for an
rset and need to remain untouched. They cannot be dropped, renamed, or
modified if the result should remain an rset.
}
\subsection{Joins}{

The following affect all of the dplyr joins, such as \code{left_join()},
\code{right_join()}, \code{full_join()}, and \code{inner_join()}.

The resulting object is an \code{rset} if the number of rows is unaffected.
Rows can be reordered but not added or removed, otherwise the resulting object
is a \code{tibble}.\tabular{lcc}{
   operation \tab same rows, possibly reordered \tab add or remove rows \cr
   \code{join(rset, tbl)} \tab \code{rset} \tab \code{tibble} \cr
}

}

\subsection{Row Operations}{

The resulting object is an \code{rset} if the number of rows is unaffected.
Rows can be reordered but not added or removed, otherwise the resulting object
is a \code{tibble}.\tabular{lcc}{
   operation \tab same rows, possibly reordered \tab add or remove rows \cr
   \code{rset[ind,]} \tab \code{rset} \tab \code{tibble} \cr
   \code{slice(rset)} \tab \code{rset} \tab \code{tibble} \cr
   \code{filter(rset)} \tab \code{rset} \tab \code{tibble} \cr
   \code{arrange(rset)} \tab \code{rset} \tab \code{tibble} \cr
}

}

\subsection{Column Operations}{

The resulting object is an \code{rset} if the required \code{splits} and \code{id} columns
remain unaltered. Otherwise the resulting object is a \code{tibble}.\tabular{lcc}{
   operation \tab required columns unaltered \tab required columns removed, renamed, or modified \cr
   \code{rset[,ind]} \tab \code{rset} \tab \code{tibble} \cr
   \code{select(rset)} \tab \code{rset} \tab \code{tibble} \cr
   \code{rename(rset)} \tab \code{rset} \tab \code{tibble} \cr
   \code{mutate(rset)} \tab \code{rset} \tab \code{tibble} \cr
}

}
}
