% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imgInt.R
\name{imgInt}
\alias{imgInt}
\title{imgInt}
\usage{
imgInt(x, x.dates, y, time.buffer)
}
\arguments{
\item{x}{Object of class \emph{RasterStack}, \emph{RasterBrick} or \emph{data.frame}.}

\item{x.dates}{Object of class \emph{Date} with dates of \emph{x}.}

\item{y}{Object of class \emph{Date} with target dates.}

\item{time.buffer}{A two-element vector with temporal search buffer (expressed in days).}
}
\value{
A \emph{RasterBrick} or a \emph{data frame}. If a \emph{RasterBrick}, each layer represents a date in \emph{y}. If a \emph{data.frame}/\emph{matrix}, columns represent dates and rows represent samples.
}
\description{
{Temporal linear interpolation of environmental data using
a \emph{raster}, \emph{SpatialPointsDataFrames} or \emph{matrix}/\emph{data.frame}.}
}
\details{
{Performs a pixel-wise linear interpolation over a raster for a given set of dates (\emph{y}).
A temporal buffer (\emph{time.buffer}) is required to limit the search for reference data points (\emph{time.buffer}).
This is defined by a two element vector which limits the search in the past and future.}
}
\examples{
{

 require(raster)

 #'  # read raster data
 file <- list.files(system.file('extdata', '', package="rsMove"), 'ndvi.tif', full.names=TRUE)
 r.stk <- stack(file)
 r.stk <- stack(r.stk, r.stk, r.stk) # dummy files for the example

 # read movement data
 data(shortMove)

 # raster dates
 file.name <- names(r.stk)
 x.dates <- as.Date(paste0(substr(file.name, 2, 5), '-',
 substr(file.name, 7, 8), '-', substr(file.name, 10, 11)))

 # interpolate raster data to target dates
 out <- imgInt(extract(r.stk, shortMove), x.dates,
 as.Date("2013-08-10"), c(60,60))

}
}
\seealso{
\code{\link{dataQuery}} \code{\link{timeDir}} \code{\link{spaceDir}} \code{\link{moveSeg}}
}
