% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getEnv.R
\name{getEnv}
\alias{getEnv}
\title{getEnv}
\usage{
getEnv(d.path = NULL, d.source = NULL, t.var = NULL, ref = NULL,
  p.raster = FALSE, p.res = NULL, pad = 10)
}
\arguments{
\item{d.path}{Output data path for downloaded data.}

\item{d.source}{Data source. One of "EarthEnv", "GFC", "GSW", "CCI" or "HSM".}

\item{t.var}{Target variable.}

\item{ref}{Projected spatial object from which an extent can be derived.}

\item{p.raster}{Logical. Should the output be reprojected?}

\item{p.res}{Pixel resolution (used if p.raster is TRUE).}

\item{pad}{Mi,ner pf cells used to pad the output raster when resampling.}
}
\value{
One or multiple raster objects.
}
\description{
Interface to download ecologically relevant data.
}
\details{
{Downloads data from earthenv.org. To check which variables can be downloaded,
run the function without specifying \emph{t.var} and specifying \emph{d.source}. This will
return a data frame listing the existing variables for a given data source. Here, the user
can refer to the column \emph{"code"} to retrieve the keywords that can be passed to
the function through \emph{t.var}. The keywords recognized by \emph{d.source} are:
\itemize{
\item{\emph{"EarthEnv"} - EarthEnv project.}
\item{\emph{"GFC"} - Maryland University Global Forest Change.}
\item{\emph{"GSW"} - JRC Global Surface Water.}
\item{\emph{"CCI"} - ESA CCI Global land cover.}
\item{\emph{"HSM"} - JRC Human Settlement map.}
\item{\emph{"NEO"} - NASA Earth Observations.}}
If \emph{t.var} contains \emph{"DEM90"} from {"EarthEv"} or any variable from \emph{"GFC"}
or \emph{"GSW"}, The function might require more time as it will mosaic the tiles with which
the rerence spatial object (\emph{ref}) overlap with. In any circunstance, the output will be
cropped to the extent of \emph{ref} and, if prompted, use it as a reference to reproject the output.}
}
\examples{
{

 # return list of variables
 ee.var <- getEnv(d.source="EarthEnv")
 gfc.var <- getEnv(d.source="GFC")
 gsw.var <- getEnv(d.source="GSW")
 cci.var <- getEnv(d.source="CCI")
 hsm.var <- getEnv(d.source="HSM")
 neo.var <- getEnv(d.source="NEO")

}
}
\references{
{\url{http://www.earthenv.org/}
\url{https://earthenginepartners.appspot.com/science-2013-global-forest}
\url{https://global-surface-water.appspot.com/} \url{http://ghsl.jrc.ec.europa.eu/}
\url{http://maps.elie.ucl.ac.be/CCI/viewer/} \url{https://neo.sci.gsfc.nasa.gov/}}
}
\seealso{
\code{\link{dataQuery}} \code{\link{proSat}}
}
