/*
 * Decompiled with CFR 0.152.
 */
package rreval;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.Socket;
import rreval.JReader;
import rreval.JWriter;

public class ConnectionJ {
    public static int MAX_WRITE_RETRIES = 16;
    public static long RETRY_NAP = 500L;
    private Socket socket;
    private ObjectInputStream ois;
    private ObjectOutputStream oos;
    private JReader jReader;
    private JWriter jWriter;
    boolean keepReading;

    public ConnectionJ(Socket socket, HostType type) throws IOException {
        this.socket = socket;
        if (HostType.server.equals((Object)type)) {
            this.ois = new ObjectInputStream(socket.getInputStream());
            this.oos = new ObjectOutputStream(socket.getOutputStream());
            this.oos.flush();
        } else if (HostType.client.equals((Object)type)) {
            this.oos = new ObjectOutputStream(socket.getOutputStream());
            this.ois = new ObjectInputStream(socket.getInputStream());
        } else {
            throw new RuntimeException("Undefinded HostType=" + (Object)((Object)type));
        }
        this.jReader = new JReader(this);
        this.jWriter = new JWriter(this);
    }

    public void write(Serializable obj) throws Exception {
        this.oos.writeObject(obj);
    }

    public Serializable read() throws Exception {
        return (Serializable)this.ois.readObject();
    }

    public void close() {
        try {
            if (this.ois != null) {
                this.ois.close();
            }
            if (this.oos != null) {
                this.oos.close();
            }
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException iox) {
            throw new RuntimeException(iox);
        }
    }

    public Serializable readMessage() {
        return this.jReader.readMessage();
    }

    public void writeMessage(Serializable obj) throws Exception {
        this.jWriter.writeMessage(obj);
    }

    public static enum HostType {
        server,
        client;

    }
}

