% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_plink_binary.R
\name{read.plink.binary}
\alias{read.plink.binary}
\title{Read PLINK binary file.}
\usage{
read.plink.binary(bed, bim = NULL, fam = NULL, na.strings = c("0", "-9"))
}
\arguments{
\item{bed, bim, fam}{PLINK files with appropriate extensions.}

\item{na.strings}{string vector, text entries to be treated as NA's.}
}
\value{
A list of three elements: \code{genotype}, \code{fam} and \code{map}.
To be consistent with PLINK .bed file, \code{genotype} is a n_subject by n_marker matrix of counts of reference alleles. Missing values are -9.
\code{fam} is a dataframe that contains the first six columns of a PLINK \code{.ped} file.
\code{map} is a dataframe that contains the four columns of a PLINK \code{.map} file, with two additional columns: \code{allele_1} for the reference allele type, \code{allele_2} for the alternate allele type.
}
\description{
\code{read.plink.binary} reads PLINK binary \code{.bed} file and the corresponding \code{.bim} and \code{.fam} file.
}
\details{
When the three files have the same name, only the \code{.bed} file needs to be specified.
}
