% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weighted_grm.R
\name{grm.pair}
\alias{grm.pair}
\title{GRM for a pair of individuals.}
\usage{
grm.pair(geno1, geno2, freq, method = "twostep", weights = NULL,
  init.est = NULL)
}
\arguments{
\item{geno1, geno2}{numeric vector.}

\item{freq}{numeric vector, values between 0 and 1.}

\item{method}{string.}

\item{weights}{numeric vector, values between 0 and 1.}

\item{init.est}{numeric.}
}
\value{
An estimate of realized relatedness.
}
\description{
\code{grm.pair} computes relatedness estimates between two individuals.
}
\details{
\code{geno1} and \code{geno2} are vectors of counts of reference alleles. \code{freq} is the vector of reference allele frequencies.

The default \code{method} is "twostep", other options include "classic", "robust" and "general". When using the default "twostep" method, user can supply an initial estimate through \code{init.est} to bypass the first step. When "general" is selected, \code{weights} must also be specified. The difference between the two-step GRM, classic GRM and robust GRM is discussed in Wang et al.  (2017).
}
\examples{
# simulate genotypes for a full sib pair
pedigree = as.character(rep(1, 4))
member = as.character(c(11, 12, 21, 22))
sex = as.numeric(c(1, 2, 1, 2))
father = as.character(c(NA, NA, 11, 11))
mother = as.character(c(NA, NA, 12, 12))
pedinfo = data.frame(pedigree, member, sex, father, mother, stringsAsFactors = FALSE)
set.seed(1)
inher = sim.recomb(pedinfo, 3500) # on a hypothetical chromosome

nsnp = 100000
marker = seq(0,3500,length.out=nsnp)
freq = runif(nsnp, 0.05, 0.95)
haplo = sim.haplotype(freq, 4)
geno = populate.snp(inher, haplo, marker, output.allele = FALSE)

# simulation truth
ibd.proportion(inher,3,4)

# different GRM estimates
grm.pair(geno[3,], geno[4,], freq, method = "twostep")
grm.pair(geno[3,], geno[4,], freq, method = "classic")
grm.pair(geno[3,], geno[4,], freq, method = "robust")
grm.pair(geno[3,], geno[4,], freq, method = "general", weights = sample(freq, nsnp)/sum(freq))

# compute the relatedness matrix
grm.matrix(geno, freq)
grm.matrix(geno, freq, method = "robust")
}
\references{
Wang et al. (2017) Genetics 205:1063-1078, \url{https://www.ncbi.nlm.nih.gov/pubmed/28100587}.
}
\seealso{
\code{\link{grm.matrix}}
}
