% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rl_narrative.R
\name{rl_narrative}
\alias{rl_narrative}
\alias{rl_narrative_}
\title{Get species narrative information by taxon name or IUCN id}
\usage{
rl_narrative(name = NULL, id = NULL, region = NULL, key = NULL,
  parse = TRUE, ...)

rl_narrative_(name = NULL, id = NULL, region = NULL, key = NULL, ...)
}
\arguments{
\item{name}{(character) Binomial taxonomic name}

\item{id}{(character) IUCN id}

\item{region}{(character) Binomial taxonomic name}

\item{key}{A IUCN API token}

\item{parse}{(logical) Whether to parse to list (\code{FALSE}) or
data.frame (\code{TRUE}). Default: \code{TRUE}}

\item{...}{Curl options passed to \code{\link[httr]{GET}}}
}
\value{
A list, with the data in the \code{result} slot, unless using
a function with a trailing underscore, in which case json as character
string is returned.
}
\description{
Get species narrative information by taxon name or IUCN id
}
\examples{
\dontrun{
rl_narrative('Fratercula arctica')
rl_narrative('Fratercula arctica', region = 'europe')
rl_narrative(id = 12392)
rl_narrative(id = 22694927, region = 'europe')

rl_narrative_('Fratercula arctica')
rl_narrative_('Fratercula arctica', region = 'europe')
}
}
\references{
API docs at \url{http://apiv3.iucnredlist.org/api/v3/docs}
}

