% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_rrd.R
\name{read_rra}
\alias{read_rra}
\title{Imports the RRA data from an RRD database}
\usage{
read_rra(filename, cf, step, n_steps, start, end = Sys.time())
}
\arguments{
\item{filename}{File name}

\item{cf}{The consolidation function that is applied to the data you want to fetch. Must be one of \code{c("AVERAGE", "MIN", "MAX", "LAST")}}

\item{step}{step}

\item{n_steps}{number of steps to return}

\item{start}{start time}

\item{end}{end time, defaults to the current system time}
}
\description{
Finds the RRA (round robin array) that best matches the \code{consolidation function} and the \code{step} and imports all values (from all data stores) in that RRA that are between timestamp \code{start} and \code{end}. Note that \code{start} is not included in the result.

Returns a \code{data.frame} object having the \code{timestamp} and the data stores as columns. The data store names are retrieved from the RRD file and set as the corresponding column names. The timestamps are also used as row names.
}
\details{
The \code{filename}, \code{cf} (consolidation function) and \code{step} arguments uniquely identify an RRA array in the RRD file.

The arguments \code{start} and \code{end} define the time-slice to be retrieved. Note that \code{start} is not included in the result. Refer to the documentation for \href{https://oss.oetiker.ch/rrdtool/doc/rrdfetch.en.html}{rrdfetch} for more information.

The returned \code{data.frame} has the \code{timestamp} and the data stores as separate columns. The names of the data sources are extracted from the RRD file and set as column names. The timestamps are also used as row names.
}
\examples{
rrd_cpu_0 <- system.file("extdata/cpu-0.rrd", package = "rrd")

# Note that the default end time is the current time (Sys.time())
# However, since the sample data is historic, specify the end time

start_time <- as.POSIXct("2018-05-01") # timestamp with data in example
end_time <- as.POSIXct("2018-05-02")   # timestamp with data in example

# read archive by specifying start time
avg_60 <- read_rra(rrd_cpu_0, cf = "AVERAGE", step = 60L, 
                     start = start_time, 
                     end = end_time)
names(avg_60)
head(avg_60)
tail(avg_60)

# read archive by specifying number of rows to retrieve
avg_60 <- read_rra(rrd_cpu_0, cf = "AVERAGE", step = 60L, 
                   n_steps = 5, 
                   end = end_time)
names(avg_60)
avg_60
}
\seealso{
Other rrd functions: \code{\link{describe_rrd}},
  \code{\link{read_rrd}}
}
\concept{rrd functions}
