% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rotate.R
\name{rray_rotate}
\alias{rray_rotate}
\title{Rotate an array}
\usage{
rray_rotate(x, from = 1, to = 2, times = 1)
}
\arguments{
\item{x}{A matrix, array, or rray.}

\item{from, to}{Single integer values. The direction of the rotation goes
from \code{from} and towards \code{to}. When using a 2D matrix, this can be thought
of as rotating \emph{counter clockwise} starting at \code{from} and going towards \code{to}.
To go \emph{clockwise}, reverse \code{from} and \code{to}.}

\item{times}{A single integer. The number of times to perform the rotation.
One of: \code{1}, \code{2}, \code{3}. Or, equivalently: \code{-3}, \code{-2}, \code{-1}.}
}
\value{
\code{x} rotated along the axis described by \code{from} and \code{to}.
}
\description{
\code{rray_rotate()} rotates an array along the plane defined by \code{c(from, to)}. It
can be thought of as sequentially rotating the array 90 degrees a set number
of \code{times}.
}
\details{
A rotation can be a hard thing to wrap your head around. I encourage
looking at the examples and starting with 2D to try and understand what
is happening before moving up to higher dimensions.

Note that a rotation is \emph{not} the same thing as a transpose.

Generally, you can predict the output of rotating using \code{from} and \code{to}
by switching the dimensions at the \code{from} and \code{to} axes position. This gives
you the shape of the output. So, a \code{(5, 2, 4)} array rotated using \code{from = 1}
and \code{to = 3} would have a resulting shape of \code{(4, 2, 5)}. Note that using
\code{from = 3} and \code{to = 1} would give the same shape. The "direction"
of how these are rotated is controlled by the ordering of \code{from} and \code{to}.
}
\examples{
# ---------------------------------------------------------------------------
# 2D example

x <- rray(1:6, c(3, 2))
x <- rray_set_row_names(x, c("r1", "r2", "r3"))
x <- rray_set_col_names(x, c("c1", "c2"))

# "counter clockwise" rotation turning the
# rows into columns
rray_rotate(x)

# "clockwise" by reversing the direction
rray_rotate(x, from = 2, to = 1)

# Rotate twice (180 degrees)
# Direction doesn't matter here, the following
# give the same result
rray_rotate(x, times = 2)
rray_rotate(x, from = 2, to = 1, times = 2)

# ---------------------------------------------------------------------------
# 3D example

x_3d <- rray_expand(x, 3)

# - Rotations on the (1, 3) axis plane
# - Dimensions go from (3, 2, 1) -> (1, 2, 3) in both cases
# - And the direction of how that happens is controlled
#   by `from` and `to`
rray_rotate(x_3d, from = 1, to = 3)

rray_rotate(x_3d, from = 3, to = 1)

}
