% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flatten.R
\name{rray_flatten}
\alias{rray_flatten}
\title{Flatten an array}
\usage{
rray_flatten(x)
}
\arguments{
\item{x}{A vector, matrix, array or rray.}
}
\value{
A 1D object with the same container type as \code{x}.
}
\description{
\code{rray_flatten()} squashes the dimensionality of \code{x} so that the result is a
1D object.
}
\details{
This function is similar to \code{as.vector()}, but keeps the class of the object
and can keep the dimension names if applicable.

Dimension names are kept using the same rules that would be applied if you
would have called \code{rray_reshape(x, prod(rray_dim(x)))}. Essentially this
means that names in the first dimension are kept if \code{x} is either already
a 1D vector, or a higher dimensional object with 1's in all dimensions
except for the first one.
}
\examples{
library(magrittr)

x <- rray(1:10, c(5, 2))

rray_flatten(x)

# Dimension names are kept here
# (2) -> (2)
y <- rray(1:2) \%>\% rray_set_axis_names(1, letters[1:2])
rray_flatten(y)

# And they are kept here
# (2, 1) -> (2)
y_one_col <- rray_reshape(y, c(2, 1))
rray_flatten(y_one_col)

# But not here, since the size of the first dim changes
# (1, 2) -> (2)
y_one_row <- t(y_one_col)
rray_flatten(y_one_row)

}
