% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dim.R
\name{rray_dim}
\alias{rray_dim}
\alias{rray_dim_common}
\title{Find common dimensions}
\usage{
rray_dim(x)

rray_dim_common(...)
}
\arguments{
\item{x}{An object.}

\item{...}{Objects to find common dimensions for.}
}
\value{
An integer vector containing the common dimensions.
}
\description{
\itemize{
\item \code{rray_dim()} finds the dimension of a single object.
\item \code{rray_dim_common()} finds the common dimensions of a set of objects.
}
}
\details{
\code{rray_dim_common()} first finds the common dimensionality,
makes any implicit dimensions explicit, then recycles the size of each
dimension to a common size.

As an example, the common dimensions of \code{(4, 5)} and \code{(4, 1, 2)} are:\preformatted{(4, 5, 1) <- implicit 1 is made to be explicit, then recycled to 2
(4, 1, 2) <- the 1 in the second dimension here is recycled to 5
---------
(4, 5, 2) <- resulting common dim
}

The resulting dimensions from \code{rray_dim_common()} are the dimensions that
are used in broadcasted operations.
}
\examples{
x_1_by_4 <- rray(c(1, 2, 3, 4), c(1, 4))
x_5_by_1 <- rray(1:5, c(5, 1))

rray_dim(x_1_by_4)

# recycle rows: 1 VS 5 = 5
# recycle cols: 4 VS 1 = 4
rray_dim_common(x_1_by_4, x_5_by_1)

x_5_by_1_by_3 <- rray(1, c(5, 1, 3))

# recycle rows:    5 VS 1 = 5
# recycle cols:    4 VS 1 = 4
# recycle 3rd dim: 1 VS 3 = 3
# (here, 3rd dim of 1 for the matrix is implicit)
rray_dim_common(x_1_by_4, x_5_by_1_by_3)

# The dimensions of NULL are 0
rray_dim(NULL)

}
\seealso{
\code{\link[=rray_dim_n]{rray_dim_n()}}
}
