% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rrreg.predictor.R
\name{predict.rrreg.predictor}
\alias{predict.rrreg.predictor}
\title{Predicted Probabilities for Randomized Response as a Regression Predictor}
\usage{
\method{predict}{rrreg.predictor}(object, fix.z = NULL, alpha = .05,
n.sims = 1000, avg = FALSE, newdata = NULL, quasi.bayes = FALSE, keep.draws
= FALSE, ...)
}
\arguments{
\item{object}{An object of class "rrreg.predictor" generated by the
\code{rrreg.predictor()} function.}

\item{fix.z}{An optional value or vector of values between 0 and 1 that the
user inputs as the proportion of respondents with the sensitive trait or
probability that each respondent has the sensitive trait, respectively. If
the user inputs a vector of values, the vector must be the length of the
data from the "rrreg.predictor" object. Default is \code{NULL} in which case
predicted probabilities are generated for the randomized response item.}

\item{alpha}{Confidence level for the hypothesis test to generate upper and
lower confidence intervals. Default is \code{.05}.}

\item{n.sims}{Number of sampled draws for quasi-bayesian predicted
probability estimation. Default is \code{1000}.}

\item{avg}{Whether to output the mean of the predicted probabilities and
uncertainty estimates. Default is \code{FALSE}.}

\item{newdata}{Optional new data frame of covariates provided by the user.
Otherwise, the original data frame from the "rreg" object is used.}

\item{quasi.bayes}{Option to use Monte Carlo simulations to generate
uncertainty estimates for predicted probabilities. Default is \code{FALSE}
meaning no uncertainty estimates are outputted.}

\item{keep.draws}{Option to return the Monte Carlos draws of the quantity of
interest, for use in calculating differences for example.}

\item{...}{Further arguments to be passed to
\code{predict.rrreg.predictor()} command.}
}
\value{
\code{predict.rrreg.predictor} returns predicted probabilities
either for each observation in the data frame or the average over all
observations. The output is a list that contains the following components:

\item{est}{Predicted probabilities of the additional outcome variable given
the randomized response item as a predictor generated either using fitted
values or quasi-Bayesian simulations. If \code{avg} is set to \code{TRUE},
the output will only include the mean estimate.} \item{se}{Standard errors
for the predicted probabilities of the additional outcome variable given the
randomized response item as a predictor generated using Monte Carlo
simulations. If \code{quasi.bayes} is set to \code{FALSE}, no standard
errors will be outputted.} \item{ci.lower}{Estimates for the lower
confidence interval. If \code{quasi.bayes} is set to \code{FALSE}, no
confidence interval estimate will be outputted.} \item{ci.upper}{Estimates
for the upper confidence interval. If \code{quasi.bayes} is set to
\code{FALSE}, no confidence interval estimate will be outputted.}
\item{qoi.draws}{Monte Carlos draws of the quantity of interest, returned
only if \code{keep.draws} is set to \code{TRUE}.}
}
\description{
\code{predict.rrreg.predictor} is used to generate predicted probabilities
from a multivariate regression object of survey data using the randomized
response item as a predictor for an additional outcome.
}
\details{
This function allows users to generate predicted probabilities for the
additional outcome variables with the randomized response item as a
covariate given an object of class "rrreg.predictor" from the
\code{rrreg.predictor()} function. Four standard designs are accepted by
this function: mirrored question, forced response, disguised response, and
unrelated question. The design, already specified in the "rrreg.predictor"
object, is then directly inputted into this function.
}
\examples{

data(nigeria)

## Define design parameters

\donttest{
set.seed(44)

p <- 2/3  # probability of answering honestly in Forced Response Design
p1 <- 1/6 # probability of forced 'yes'
p0 <- 1/6 # probability of forced 'no'

## Fit joint model of responses to an outcome regression of joining a civic 
## group and the randomized response item of having a militant social connection

rr.q1.pred.obj <- 
    rrreg.predictor(civic ~ cov.asset.index + cov.married + I(cov.age/10) + 
              I((cov.age/10)^2) + cov.education + cov.female 
              + rr.q1, rr.item = "rr.q1", parstart = FALSE, estconv = TRUE,
              data = nigeria, verbose = FALSE, optim = TRUE,
              p = p, p1 = p1, p0 = p0, design = "forced-known")

## Generate predicted probabilities for the likelihood of joining 
## a civic group across respondents using quasi-Bayesian simulations. 

rr.q1.rrreg.predictor.pred <- predict(rr.q1.pred.obj, 
                                 avg = TRUE, quasi.bayes = TRUE, 
                                 n.sims = 1000)
}
}
\references{
Blair, Graeme, Kosuke Imai and Yang-Yang Zhou. (2014) "Design
and Analysis of the Randomized Response Technique."  \emph{Working Paper.}
Available at \url{http://imai.princeton.edu/research/randresp.html}.
}
\seealso{
\code{\link{rrreg.predictor}} to conduct multivariate regression
analyses with the randomized response as predictor in order to generate
predicted probabilities.
}
\keyword{fitted}
\keyword{predicted}
\keyword{probabilities}
\keyword{values}
