% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/q.test.R
\name{q.test}
\alias{q.test}
\title{Hypothesis Tests and Confidence Intervals for functions of quantiles}
\usage{
q.test(
  x,
  y = NULL,
  measure = "median",
  u = NULL,
  coef = NULL,
  u2 = NULL,
  coef2 = NULL,
  quantile.type = 8,
  var.method = "qor",
  alternative = c("two.sided", "less", "greater"),
  conf.level = 0.95,
  true.q = 0,
  log.transf = FALSE,
  back.transf = FALSE,
  min.q = -Inf,
  p = NULL,
  ...
)
}
\arguments{
\item{x}{a numeric vector of data values.}

\item{y}{an optional second vector of data values for two-sample testing.}

\item{measure}{a character string specifying the quantile measure to be estimated (See details).}

\item{u}{a numeric vector of probability values in [0, 1] indicating all quantiles to be estimated.}

\item{coef}{a vector or matrix with two rows specifying the coefficients that define the linear combinations (coefficients must match the corresponding probability values in u). If coef is a vector then a single linear combination (LC) is computed. If it is a matrix, then first row defines the numerator LS and the second the denominator LC.}

\item{u2}{a numeric vector of probability values in [0, 1] indicating all quantiles to be estimated for the denominator.}

\item{coef2}{a vector specifying the coefficients that define the linear combination for the denominator.  This is can be used as an alternative to defining coef as matrix for ratios of linear combinations.}

\item{quantile.type}{argument for the quantile function.  Default is set to 8 so that output is consistent with default quantile function use and other functions such as IQR (see help file for \code{quantile()}
for more details)}

\item{var.method}{approach use to estimate the quantile density function.  Either "qor"(default) or "density" (See details).}

\item{alternative}{a character string for alternative hypothesis equal to one of "two.sided", "greater" or "less".}

\item{conf.level}{coverage for the estimated confidence interval.}

\item{true.q}{a numeric value for the true value under the null hypothesis test.}

\item{log.transf}{boolean indicating whether the a log transformation of the measure is to be used (i.e., estimates of the log of the measure are computed).}

\item{back.transf}{boolean indicating whether the measure and estimates should be back-transformed  to the original scale using exp.}

\item{min.q}{the lower bound for a one-sided confidence interval when alternative  argument if "less".}

\item{p}{optional value in (0, 1) for Bowley's generalized skewness coefficient.}

\item{...}{additional arguments to be passed to function qcov when var.method = “density” is used.}
}
\value{
hypothesis test results and associated confidence interval (a list with class "htest")
}
\description{
carry out hypothesis tests and obtain associated confidence intervals for linear combinations of quantiles,
and ratios of such linear combinations.
}
\details{
This function \code{q.test} performs hypothesis tests and calculates confidence intervals for linear combinations of quantiles.
The quantile measures that can be estimated are specified in the \code{measure} argument and are listed below.
\itemize{
\item \code{median}: The default choice.
\item \code{iqr}: The interquartile range.
\item \code{rCViqr}: The robust Coefficient of Variation measure (Arachchige et al.,2022)
\item \code{bowley}, \code{groenR} and \code{groenL}: These choices are for Bowley's skew coefficient,
for the generalized measure, and the right and left skew measures by Groeneveld and Meeden (Groeneveld & Meeden, 1984, 2009). For each of these measures, the user may specify the choice of p using argument \code{p}.  If this is not used, then the default is \code{p=0.25}.
\item \code{moors}: This Moors kurtosis measure (Moors, 1988).
\item \code{lqw} and \code{rqw}: These are for the robust left and right tail weights (Brys et al., 2006).
\item \code{qrxxyy}: A character string consisting of the first two characters "qr" and followed by four numbers will request a ratio of dependents quantiles (i.e. different quantiles from the same sample).The first two number digits (in place of "xx") will indicate the quantile for the numerator, and the second two numerical digits "yy" for the denominator.  For example, \code{qr9010} will estimate and test the ratio Q(0.9)/Q(0.1).
}

The default \code{var.method="qor"} is to estimate the probability density function directly using the lognormal Quantile Optimality Ratio (QOR)
for choosing a suitable bandwidth (Prendergast & Staudte,2016). Alternatively, the variances can be
estimated by inverting a density estimator evaluated at the quantiles and this can be done using \code{var.method = "density"}. If \code{var.method = "density"},
then the function density is used to estimate the probability density function which is needed for the calculation of the covariance matrix using function qcov.
If needed, additional arguments can be passed to density (see ?density for details on possible additional arguments).

Additional to using a text string with argument measure to indicate which quantile-based measure is to be used (of those included for the \code{q.test} function),
users can also define and request their own.  For example, while the median is the default for a single quantile, other quantiles can also be requested
(e.g., \code{u = 0.25} will request the first quartile).  This option is also included for linear combinations of quantiles and ratios of linear combinations,
which can be done in two ways.  For a single linear combination, argument \code{u} is the vector of probability values defining the quantiles to be used,
and argument \code{coef} is a vector of coefficients for the linear combination.  If a ratio is needed, then \code{u} and \code{coef} are used for the numerator and \code{u2} and \code{coef2}
for the denominator linear combination.  Alternatively, a single \code{u} can be used to identify all quantiles for the ratio, and then \code{coef} can be a matrix (2 rows)
whose first row specifies the coefficients for the numerator and the second row for the denominator. For more information and further examples,
see Prendergast, Dedduwakumara & Staudte (2024), and the example code below shows how to obtain results for
the robust CVs using all three approaches (to achieve identical results).

Further details on confidence intervals, including coverage properties of, can be found for ratios of dependent quantiles (Prendergast & Staudte, 2017),
ratios of independent quantiles and IQRs (Arachchige et al., 2021) and for robust CVs (Arachchige et al., 2022).
}
\examples{

#  Create some data
x <- c(8.43,7.08,8.79,8.88,7.87,5.94,8.79,5.46,8.11,7.08)
y <- c(13.44,13.65,14.77,9.51,14.07,10.92,11.59,13.42,8.93,10.88)

# One sample hypothesis test for the IQR
q.test(x, measure = "iqr")

# Two samples hypothesis test for robust coefficient variations (0.75*IQR/median)
# with log transformation and back-transformation to the ratio scale,.
q.test(x, y, measure = "rCViqr", log.transf = TRUE, back.transf = TRUE)

# The same two samples hypothesis test for robust coefficient variations (0.75*IQR/median)
# by using 'u',''u2','coef' and 'coef2' arguments.
u<-c(0.25,0.75)
coef<-0.75*c(-1,1)
u2<-0.5
coef2<-1
q.test(x,y,u=u,u2=u2,coef=coef,coef2=coef2,log.transf=TRUE,back.transf=TRUE)

# The same two samples hypothesis test for robust coefficient variations (0.75*IQR/median)
# by using only 'u' and 'coef' arguments.
u<-c(0.25,0.5,0.75)
num <- 0.75*c(-1,0,1)
den <- c(0,1,0)
coef <- rbind(num, den)
q.test(x,y,u=u,coef=coef,log.transf=TRUE,back.transf=TRUE)
}
\references{
Arachchige, C. N., Cairns, M., & Prendergast, L. A. (2021). Interval estimators for ratios of independent quantiles and interquantile ranges.
Communications in Statistics-Simulation and Computation, 50(12), 3914-3930.

Arachchige, C.N.P.G., Prendergast, L.A., & Staudte, R.G. (2022). Robust Analogs to the Coefficient of
Variation. Journal of Applied Statistics, 49(2), 268–290.

Brys, G., Hubert, M., & Struyf, A. (2006). Robust measures of tail weight. Computational Statistics & Data
Analysis, 50(3), 733–759.

Groeneveld, R. A., & Meeden, G. (1984). Measuring skewness and kurtosis. Journal of the Royal Statistical
Society Series D: The Statistician, 33(4), 391–399.

Groeneveld, R. A., & Meeden, G. (2009). An improved skewness measure. Metron, 67(3), 325.

Hyndman, R.J., & Fan, Y. (1996). Sample quantiles in statistical packages. The American Statistician, 50(4),
361–365.

Moors, J. J. A. (1988). A quantile alternative for kurtosis. Journal of the Royal Statistical Society:
Series D (The Statistician), 37(1), 25–32.

Prendergast, L. A., & Staudte, R. G. (2016). Exploiting the quantile optimality ratio in finding confidence intervals for quantiles. Stat, 5(1), 70-81

Prendergast, L. A., & Staudte, R. G. (2017). When large n is not enough–distribution-free interval estimators for ratios of quantiles.
The Journal of Economic Inequality, 15, 277-293.

Prendergast, L. A., Dedduwakumara, D.S. & Staudte, R.G. (2024) rquest: An R package for hypothesis tests and confidence intervals
for quantiles and summary measures based on quantiles, preprint, pages 1-13
}
