% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/section_builder.R
\name{section}
\alias{section}
\title{Create a section as part of a test content}
\usage{
section(
  content,
  n_variants = 1L,
  seed_number = NULL,
  id = NULL,
  by = "variants",
  selection = NULL,
  title = character(0),
  time_limits = NA_integer_,
  visible = TRUE,
  shuffle = FALSE,
  max_attempts = NA_integer_,
  allow_comment = TRUE
)
}
\arguments{
\item{content}{A character vector of Rmd, md, xml files, task- or
section-objects.}

\item{n_variants}{An integer value indicating the number of task variants to
create from Rmd files. Default is \code{1}.}

\item{seed_number}{An integer vector, optional, specifying seed numbers to
reproduce the result of calculations.}

\item{id}{A character value, optional, serving as the identifier of the
assessment section.}

\item{by}{A character with two possible values: "variants" or "files",
indicating the type of the test structure. Default is "variants".}

\item{selection}{An integer value, optional, defining how many children of
the section are delivered in the test. Default is \code{NULL}, meaning "no
selection".}

\item{title}{A character value, optional, representing the title of the
section. If not provided, it defaults to \code{identifier}.}

\item{time_limits}{An integer value, optional, controlling the amount of time
a candidate is allowed for this part of the test.}

\item{visible}{A boolean value, optional, indicating whether the title of
this section is shown in the hierarchy of the test structure. Default is
\code{TRUE}.}

\item{shuffle}{A boolean value, optional, responsible for randomizing the
order in which the assessment items and subsections are initially presented
to the candidate. Default is \code{FALSE}.}

\item{max_attempts}{An integer value, optional, enabling the maximum number
of attempts allowed for a candidate to pass this section.}

\item{allow_comment}{A boolean value, optional, enabling candidates to leave
comments on each question of the section. Default is \code{TRUE}.}
}
\value{
An object of class \link{AssessmentSection}.
}
\description{
Create an AssessmentSection \code{rqti}-object as part of a test content
}
\examples{
sc <- new("SingleChoice", prompt = "Question", choices = c("A", "B", "C"))
es <- new("Essay", prompt = "Question")
# Since ready-made S4 "AssessmentItem" objects are taken, in this example a
#permanent section consisting of two tasks is created.
s <- section(c(sc, es), title = "Section with nonrandomized tasks")

# Since Rmd files with randomization of internal variables are taken,
#in this example 2 variants are created with a different seed number for each.
path <- system.file("rmarkdown/templates/", package='rqti')
file1 <- file.path(path, "singlechoice-simple/skeleton/skeleton.Rmd")
file2 <- file.path(path, "singlechoice-complex/skeleton/skeleton.Rmd")
s <- section(c(file1, file2), n_variants = 2,
title = "Section with two variants of tasks")
}
\seealso{
\code{\link[=test]{test()}}, \code{\link[=test4opal]{test4opal()}}
}
