% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knit_functions.R
\name{render_opal}
\alias{render_opal}
\title{Render Rmd directly in Opal via API}
\usage{
render_opal(input, ...)
}
\arguments{
\item{input}{(the path to the input Rmd document)}

\item{...}{required for passing arguments when knitting}
}
\value{
A list with the key, display name, and URL of the resource in Opal.
}
\description{
Render Rmd directly in Opal via API
}
\details{
Customize knit function in the Rmd file using the following YAML setting
after the word knit \code{knit: rqti::render_opal}.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
file <- system.file("exercises/sc1.Rmd", package='rqti')
render_opal(file)
\dontshow{\}) # examplesIf}
}
