% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/execute_parallel.R
\name{ex_data_table_parallel}
\alias{ex_data_table_parallel}
\title{Execute an \code{rquery} pipeline with \code{data.table} in parallel.}
\usage{
ex_data_table_parallel(
  optree,
  partition_column,
  cl = NULL,
  ...,
  tables = list(),
  source_limit = NULL,
  debug = FALSE,
  env = parent.frame()
)
}
\arguments{
\item{optree}{relop operations tree.}

\item{partition_column}{character name of column to partition work by.}

\item{cl}{a cluster object, created by package parallel or by package snow. If NULL, use the registered default cluster.}

\item{...}{not used, force later arguments to bind by name.}

\item{tables}{named list map from table names used in nodes to data.tables and data.frames.}

\item{source_limit}{if not null limit all table sources to no more than this many rows (used for debugging).}

\item{debug}{logical if TRUE use lapply instead of parallel::clusterApplyLB.}

\item{env}{environment to look for values in.}
}
\value{
resulting data.table (intermediate tables can sometimes be mutated as is practice with data.table).
}
\description{
Execute an \code{rquery} pipeline with \code{data.table} in parallel, partitioned by a given column.
Note: usually the overhead of partitioning and distributing the work will by far overwhelm any parallel speedup.
Also \code{data.table} itself already seems to exploit some thread-level parallelism (one often sees user time > elapsed time).
Requires the \code{parallel} package.  For a worked example with significant speedup please see \url{https://github.com/WinVector/rqdatatable/blob/master/extras/Parallel_rqdatatable.md}.
}
\details{
Care must be taken that the calculation partitioning is course enough to ensure a correct calculation.  For example: anything
one is joining on, aggregating over, or ranking over must be grouped so that all elements affecting a given result row are
in the same level of the partition.
}
