% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mainFunctions.R
\name{predict.qic.select}
\alias{predict.qic.select}
\title{Predictions from a qic.select object}
\usage{
\method{predict}{qic.select}(object, newx, sort = FALSE, ...)
}
\arguments{
\item{object}{qic.select object}

\item{newx}{Data matrix to make predictions from.}

\item{sort}{If there are crossing quantiles the predictions will be sorted to avoid this issue.}

\item{...}{No additional parameters are used but this is needed for how R handles predict functions.}
}
\value{
A matrix of predicted values.
}
\description{
Predictions from a qic.select object
}
\examples{
x <- matrix(runif(800),ncol=8)
y <- 1 + x[,1] + x[,8] + (1+.5*x[,3])*rnorm(100)
m1 <- rq.pen(x,y,tau=c(.25,.75))
q1 <- qic.select(m1)
newx <- matrix(runif(80),ncol=8)
preds <- predict(q1,newx)
}
\author{
Ben Sherwood, \email{ben.sherwood@ku.edu}
}
