% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QICD_functions.R
\name{QICD}
\alias{QICD}
\title{Implements QICD algorithm}
\usage{
QICD(
  y,
  x,
  tau = 0.5,
  lambda,
  intercept = TRUE,
  penalty = "SCAD",
  initial_beta = NULL,
  maxin = 100,
  maxout = 20,
  eps = 1e-05,
  coef.cutoff = 1e-08,
  a = 3.7,
  scalex = TRUE,
  ...
)
}
\arguments{
\item{y}{response variable, length n vector}

\item{x}{input nxp matrix, of dimension nobs x nvars; each row is an observation vector.}

\item{tau}{the quantile value}

\item{lambda}{the tuning parameter (numeric value > 0)}

\item{intercept}{a logical value,should intercept be fitted (default=TRUE) (intercept should be included when using splines)}

\item{penalty}{The name of the penalty function ("SCAD", "MCP", "LASSO")}

\item{initial_beta}{Vector containing initial values for intercept (if included) and x coefficients. Should be in the form (intercept, coefficients) intercept should be left out if intercept=FALSE.}

\item{maxin}{maximum number of iterations for inside coordinate descent,default value is 100}

\item{maxout}{maximum number of iterations for outside MM step, default value is 20}

\item{eps}{The convergence threshold for coordinate descent and majorization minimization step}

\item{coef.cutoff}{Threshold for determining nonzero coefficients}

\item{a}{Scale parameter, the default value is 3.7 (>2 for SCAD, >1 for MCP, not used in LASSO)}

\item{scalex}{Whether predictors are centered and scaled}

\item{...}{additional parameters}
}
\description{
Implements QICD algorithm
}
\keyword{internal}
