% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phylopic_utils.R
\name{recolor_phylopic}
\alias{recolor_phylopic}
\title{Recolor a PhyloPic image}
\usage{
recolor_phylopic(
  img,
  alpha = 1,
  color = NULL,
  fill = NULL,
  remove_background = TRUE
)
}
\arguments{
\item{img}{A \link[grImport2:Picture-class]{Picture} or png array object, e.g.,
from using \code{\link[=get_phylopic]{get_phylopic()}}.}

\item{alpha}{\code{numeric}. A value between 0 and 1, specifying the opacity
of the silhouette.}

\item{color}{\code{character}. Color to make the outline of the silhouette.
If NULL, the outline color is not changed.}

\item{fill}{\code{character}. Color to make the body of the silhouette. If
NULL, the body color is not changed.}

\item{remove_background}{\code{logical}. Should any white background be
removed? Only useful if \code{img} is a \link[grImport2:Picture-class]{Picture}
object. See details.}
}
\value{
A \link[grImport2:Picture-class]{Picture} or png array object (matching
the type of \code{img})
}
\description{
Function to recolor and change alpha levels of a PhyloPic image.
}
\details{
Some PhyloPic silhouettes do not have a transparent background.
Consequently, when color is used with vectorized versions of these images,
the entire image--including the background--is recolored. Setting
\code{remove_background} to \code{TRUE} (the default) will remove any white parts of
the image (which should only be the background).
}
\seealso{
Other transformations: 
\code{\link{flip_phylopic}()},
\code{\link{rotate_phylopic}()}
}
\concept{transformations}
