% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_phylopic.r
\name{add_phylopic}
\alias{add_phylopic}
\title{Add a PhyloPic to a ggplot plot}
\usage{
add_phylopic(
  img = NULL,
  name = NULL,
  uuid = NULL,
  x = NULL,
  y = NULL,
  ysize = NULL,
  alpha = 1,
  color = "black"
)
}
\arguments{
\item{img}{A \link[grImport2:Picture-class]{Picture} or png array object, e.g.,
from using \code{\link[=get_phylopic]{get_phylopic()}}.}

\item{name}{A taxonomic name to be passed to \code{\link[=get_uuid]{get_uuid()}}.}

\item{uuid}{A valid uuid for a PhyloPic silhouette (such as that returned by
\code{\link[=get_uuid]{get_uuid()}} or \code{\link[=pick_phylopic]{pick_phylopic()}}).}

\item{x}{x value of the silhouette center. Ignored if \code{y} and \code{ysize} are not
specified.}

\item{y}{y value of the silhouette center. Ignored if \code{x} and \code{ysize} are not
specified.}

\item{ysize}{Height of the silhouette. The width is determined by the aspect
ratio of the original image. Ignored if \code{x} and \code{y} are not specified.}

\item{alpha}{A value between 0 and 1, specifying the opacity of the
silhouette (0 is fully transparent, 1 is fully opaque).}

\item{color}{Color to plot the silhouette in.}
}
\description{
Specify an existing image, taxonomic name, or PhyloPic uuid to add a PhyloPic
silhouette as a separate layer to an existing ggplot plot.
}
\details{
One (and only one) of \code{img}, \code{name}, or \code{uuid} must be specified.
Use parameters \code{x}, \code{y}, and \code{ysize} to place the silhouette at a specified
position on the plot. If all three of these parameters are unspecified,
then the silhouette will be plotted to the full height and width of the
plot. The aspect ratio of the silhouette will always be maintained.
}
\examples{
# Put a silhouette behind a plot based on a taxonomic name
library(ggplot2)
ggplot(iris) +
  add_phylopic(name = "Iris", alpha = .2) +
  geom_point(aes(x = Sepal.Length, y = Sepal.Width))

# Put a silhouette anywhere based on UUID
posx <- runif(10, 0, 10)
posy <- runif(10, 0, 10)
sizey <- runif(10, 0.4, 2)
cols <- sample(c("black", "darkorange", "grey42", "white"), 10,
  replace = TRUE)

# Since we are plotting a lot of the same image, we should just save
# the image in our environment first
cat <- get_phylopic("23cd6aa4-9587-4a2e-8e26-de42885004c9")
p <- ggplot(data.frame(cat.x = posx, cat.y = posy), aes(cat.x, cat.y))
for (i in 1:10) {
  p <- p + add_phylopic(cat, x = posx[i], y = posy[i],
                        ysize = sizey[i], color = cols[i])
}
p + ggtitle("R Cat Herd!!")
}
