% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_design_utilities.R
\name{utilitiesForPiecewiseExponentialDistribution}
\alias{utilitiesForPiecewiseExponentialDistribution}
\alias{getPiecewiseExponentialDistribution}
\alias{ppwexp}
\alias{getPiecewiseExponentialQuantile}
\alias{qpwexp}
\alias{getPiecewiseExponentialRandomNumbers}
\alias{rpwexp}
\title{The Piecewise Exponential Distribution}
\usage{
getPiecewiseExponentialDistribution(
  time,
  ...,
  piecewiseSurvivalTime = NA_real_,
  piecewiseLambda = NA_real_,
  kappa = 1
)

ppwexp(t, ..., s = NA_real_, lambda = NA_real_, kappa = 1)

getPiecewiseExponentialQuantile(
  quantile,
  ...,
  piecewiseSurvivalTime = NA_real_,
  piecewiseLambda = NA_real_,
  kappa = 1
)

qpwexp(q, ..., s = NA_real_, lambda = NA_real_, kappa = 1)

getPiecewiseExponentialRandomNumbers(
  n,
  ...,
  piecewiseSurvivalTime = NA_real_,
  piecewiseLambda = NA_real_,
  kappa = 1
)

rpwexp(n, ..., s = NA_real_, lambda = NA_real_, kappa = 1)
}
\arguments{
\item{...}{Ensures that all arguments (starting from the "...") are to be named and 
that a warning will be displayed if unknown arguments are passed.}

\item{kappa}{A numeric value > 0. A \code{kappa != 1} will be used for the specification 
of the shape of the Weibull distribution. 
Default is \code{1}, i.e., the exponential survival distribution is used instead of the Weibull distribution.
Note that the Weibull distribution cannot be used for the piecewise definition of 
the survival time distribution, i.e., only \code{piecewiselambda} (as a single value) and \code{kappa} 
can be specified.
This function is equivalent to \code{pweibull(t, shape = kappa, scale = 1 / lambda)} 
of the \code{stats} package, i.e., the scale parameter is \code{1 / 'hazard rate'}.\cr
For example, 
\code{getPiecewiseExponentialDistribution(time = 130, piecewiseLambda = 0.01, kappa = 4.2)} 
and \code{pweibull(q = 130, shape = 4.2, scale = 1 / 0.01)} provide the sample result.}

\item{t, time}{Vector of time values.}

\item{s, piecewiseSurvivalTime}{Vector of start times defining the "time pieces".}

\item{lambda, piecewiseLambda}{Vector of lambda values (hazard rates) corresponding to the start times.}

\item{q, quantile}{Vector of quantiles.}

\item{n}{Number of observations.}
}
\value{
A \code{\link[base]{numeric}} value or vector will be returned.
}
\description{
Distribution function, quantile function and random number generation for the
piecewise exponential distribution.
}
\details{
\code{getPiecewiseExponentialDistribution} (short: \code{ppwexp}),
\code{getPiecewiseExponentialQuantile} (short: \code{qpwexp}), and
\code{getPiecewiseExponentialRandomNumbers} (short: \code{rpwexp}) provide
probabilities, quantiles, and random numbers according to a piecewise
exponential or a Weibull distribution.
The piecewise definition is performed through a vector of
starting times (\code{piecewiseSurvivalTime}) and a vector of hazard rates (\code{piecewiseLambda}).
You can also use a list that defines the starting times and piecewise
lambdas together and define piecewiseSurvivalTime as this list.
The list needs to have the form, e.g.,
piecewiseSurvivalTime <- list(
    "0 - <6"   = 0.025,
    "6 - <9"   = 0.04,
    "9 - <15"  = 0.015,
    ">=15"      = 0.007) .
For the Weibull case, you can also specify a shape parameter kappa in order to
calculate probabilities, quantiles, or random numbers.
In this case, no piecewise definition is possible, i.e., only piecewiseLambda
(as a single value) and kappa need to be specified.
}
\examples{
# Calculate probabilties for a range of time values for a
# piecewise exponential distribution with hazard rates
# 0.025, 0.04, 0.015, and 0.007 in the intervals
# [0, 6), [6, 9), [9, 15), [15, Inf), respectively,
# and re-return the time values:
piecewiseSurvivalTime <- list(
    "0 - <6"   = 0.025,
    "6 - <9"   = 0.04,
    "9 - <15"  = 0.015,
    ">=15"     = 0.01
)
y <- getPiecewiseExponentialDistribution(seq(0, 150, 15),
    piecewiseSurvivalTime = piecewiseSurvivalTime
)
getPiecewiseExponentialQuantile(y,
    piecewiseSurvivalTime = piecewiseSurvivalTime
)

}
