% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_tilespec.R
\name{as.tile_source}
\alias{as.tile_source}
\alias{is.tile_source}
\alias{source_from_url_format}
\title{Tile Sources}
\usage{
as.tile_source(x, ...)

is.tile_source(x)

source_from_url_format(
  url_format,
  max_zoom = tile.maxzoom.default(),
  min_zoom = 0,
  attribution = NULL,
  extension = tools::file_ext(url_format[1]),
  ...
)
}
\arguments{
\item{x}{An object (usually a name or string format) with which to create a tile source}

\item{...}{Arguments passed to other methods}

\item{url_format}{A string in the form \code{https://tiles.wmflabs.org/bw-mapnik/${z}/${x}/${y}.png},
where z, x, and y are the zoom, xtile, and ytile, respectively. Also valid is ${q}, which
will be passed a quadkey.}

\item{max_zoom}{An integer specifying the maximum zoom to use (default is 19)}

\item{min_zoom}{An integer specifying the minimum zoom to use (default is 1)}

\item{attribution}{An attribution string, required by some tile providers.}

\item{extension}{An extension string, used to generate the cache file name and
determine whether to use png or jpeg to read the cached file.}
}
\value{
An object of class 'tile_source'
}
\description{
Tile sources define where rosm looks for map tiles. There are a number of
built-in types (\link{osm.types}), or they can be created using \code{as.tile_source()},
registered using \link{register_tile_source} for easy access, or passed directly to
the \link{osm.plot} family of methods.
}
\details{
Passing a name from \link{osm.types} will return that tile source; passing a name from
\link{register_tile_source} will return that tile source, and passing a URL format in the form
\code{https://tiles.wmflabs.org/bw-mapnik/${z}/${x}/${y}.png} will create a new tile source.
Old style function names in the form tile.url.TYPE are still supported but are deprecated.
}
\examples{
# get builtin tile sources
as.tile_source("osm")

# get custom tile sources
as.tile_source("http://a.basemaps.cartocdn.com/dark_all/${z}/${x}/${y}.png")

# get registered tile sources
register_tile_source(dark = "http://a.basemaps.cartocdn.com/dark_all/${z}/${x}/${y}.png")
as.tile_source("dark")

# create more complex tile sources using source_from_url_format
source_from_url_format("http://a.basemaps.cartocdn.com/dark_all/${z}/${x}/${y}.png",
                       attribution = "Tiles by CartoDB")

# test for tile sources
is.tile_source(as.tile_source("osm"))

}
