% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scatterPlot.R
\name{scatterPlot}
\alias{scatterPlot}
\title{Easy ggplot2 scatter plots}
\usage{
scatterPlot(
  x,
  y,
  pointsize = 3,
  theme = theme_bw(),
  regrLine = FALSE,
  regrCI = FALSE,
  regrLineCol = "blue",
  regrCIcol = regrLineCol,
  regrCIalpha = 0.25,
  width = 0,
  height = 0,
  position = "identity",
  xVarName = NULL,
  yVarName = NULL,
  ...
)
}
\arguments{
\item{x}{The variable to plot on the X axis.}

\item{y}{The variable to plot on the Y axis.}

\item{pointsize}{The size of the points in the scatterplot.}

\item{theme}{The theme to use.}

\item{regrLine}{Whether to show the regression line.}

\item{regrCI}{Whether to display the confidence interval around the
regression line.}

\item{regrLineCol}{The color of the regression line.}

\item{regrCIcol}{The color of the confidence interval around the regression
line.}

\item{regrCIalpha}{The alpha value (transparency) of the confidence interval
around the regression line.}

\item{width}{If \code{position} is \code{'jitter'}, the points are 'jittered': some
random noise is added to change their location slightly. In that case
'width' can be set to determine how much the location should be allowed to
vary on the X axis.}

\item{height}{If \code{position} is \code{'jitter'}, the points are 'jittered':
some random noise is added to change their location slightly. In that case
'height' can be set to determine how much the location should be allowed to
vary on the Y axis.}

\item{position}{Whether to 'jitter' the points (adding some random noise to
change their location slightly, used to prevent overplotting). Set to
\code{'jitter'} to jitter the points.}

\item{xVarName, yVarName}{Can be used to manually specify the names of the
variables on the x and y axes.}

\item{\dots}{And additional arguments are passed to \code{\link[ggplot2:geom_point]{ggplot2::geom_point()}}
or \code{\link[ggplot2:geom_jitter]{ggplot2::geom_jitter()}} (if \code{jitter} is set to \code{'jitter'}).}
}
\value{
A \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} plot is returned.
}
\description{
This function is intended to provide a very easy interface to generating
pretty (and pretty versatile) \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} scatter plots.
}
\details{
Note that if \code{position} is set to \code{'jitter'}, unless \code{width} and/or
\code{height} is set to a non-zero value, there will still not be any
jittering.
}
\examples{
### A simple scatter plot
rosetta::scatterPlot(
  mtcars$mpg, mtcars$hp
);

### The same scatter plot, now with a regression line
### and its confidence interval added.
rosetta::scatterPlot(
  mtcars$mpg, mtcars$hp,
  regrLine=TRUE,
  regrCI=TRUE
);

}
